/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adxadvertiserinfo;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.bes.BesAdvertiserInfo;
import com.bxm.adsmanager.model.dto.bes.AdxAdvertiserSearchDTO;
import com.bxm.adsmanager.model.dto.bes.AuthHeader;
import com.bxm.adsmanager.model.dto.bes.MeiTuanAdvertiserAuditDTO;
import com.bxm.adsmanager.model.enums.BesStatusEnum;
import com.bxm.adsmanager.model.vo.bes.BesAdvertiserInfoDetailVO;
import com.bxm.adsmanager.service.adxadvertiserinfo.AdxAdvertiserInfoService;
import com.bxm.adsmanager.service.review.ReviewRequest;
import com.bxm.adsmanager.service.review.ReviewResult;
import com.bxm.adsmanager.service.review.meituan.MeiTuanCreative;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/meituanAdvertiserInfo"})
public class MeiTuanAdvertiserInfoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeiTuanAdvertiserInfoController.class);
    @Autowired
    private AdxAdvertiserInfoService adxAdvertiserInfoService;
    @Autowired
    private AuthHeader authHeader;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private MeiTuanCreative meiTuanCreative;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo> findAll(HttpServletRequest request, HttpServletResponse response, AdxAdvertiserSearchDTO adxAdvertiserSearchDTO) {
        ResultModel rs = new ResultModel();
        try {
            adxAdvertiserSearchDTO.setAdxAdvertiserType(Integer.valueOf(2));
            PageInfo page = this.adxAdvertiserInfoService.findPage(adxAdvertiserSearchDTO);
            if (page != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)page);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u7f8e\u56e2\u5e7f\u544a\u4e3b\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u7f8e\u56e2\u5e7f\u544a\u4e3b\u4fe1\u606f\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public ResultModel<BesAdvertiserInfoDetailVO> get(@NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="id") @NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Integer id) throws Exception {
        ResultModel rs = new ResultModel();
        BesAdvertiserInfoDetailVO besAdvertiserInfoDetailVO = this.adxAdvertiserInfoService.getDetail(id);
        rs.setSuccessed(true);
        rs.setReturnValue((Object)besAdvertiserInfoDetailVO);
        return rs;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(@RequestBody BesAdvertiserInfo besAdvertiserInfo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        besAdvertiserInfo.setAdxAdvertiserType(Integer.valueOf(2));
        this.adxAdvertiserInfoService.add(besAdvertiserInfo);
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/audit"}, method={RequestMethod.POST})
    public ResultModel audit(@RequestBody MeiTuanAdvertiserAuditDTO meiTuanAdvertiserAuditDTO, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BesAdvertiserInfo entity = this.adxAdvertiserInfoService.get(meiTuanAdvertiserAuditDTO.getId());
        if (2 != entity.getAdxAdvertiserType()) {
            throw new ValidateException("\u8be5\u63a5\u53e3\u53ea\u80fd\u63d0\u4ea4\u5ba1\u6838\u7f8e\u56e2\u5e7f\u544a\u4e3b\uff01");
        }
        List adShopMsgs = this.adShopIntegration.findAdShopMsgs(String.valueOf(meiTuanAdvertiserAuditDTO.getAdvertiserId()));
        if (CollectionUtils.isEmpty((Collection)adShopMsgs)) {
            throw new ValidateException("\u6ca1\u6709\u627e\u5230\u5e7f\u544a\u4e3b\u6570\u636e\uff01");
        }
        AdvertiserDto advertiserDto = (AdvertiserDto)adShopMsgs.get(0);
        ReviewRequest reviewRequest = ReviewRequest.builder().meiTuanAdvertiserAuditDTO(meiTuanAdvertiserAuditDTO).advertiserDto(advertiserDto).build();
        ReviewResult reviewResult = this.meiTuanCreative.submitAdv(reviewRequest);
        if (Objects.isNull(reviewResult)) {
            throw new BusinessException("ADX\u5ba1\u6838\u7ed3\u679c\u4e3a\u7a7a");
        }
        Map submitAdvResultMap = reviewResult.getResult();
        Long adxAdvertiserId = (Long)submitAdvResultMap.get(String.valueOf(meiTuanAdvertiserAuditDTO.getAdvertiserId()));
        if (Objects.nonNull(adxAdvertiserId)) {
            entity.setAdxAdvertiserId(String.valueOf(adxAdvertiserId));
            entity.setAuditState(Integer.valueOf(BesStatusEnum.PASS.getLogicStatus()));
        } else {
            entity.setAdxAdvertiserId(null);
            entity.setAuditState(Integer.valueOf(BesStatusEnum.REFUSE.getLogicStatus()));
        }
        this.adxAdvertiserInfoService.update(entity);
        return ResultModelFactory.SUCCESS();
    }
}

