/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.agencychannel;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannelData;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AgencyChannelDataBatchUpdateDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelDataDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelDataImportExcelDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelDataSearchDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelDataSyncDTO;
import com.bxm.adsmanager.service.agencychannel.AgencyChannelDataService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/agencyChannelData"})
public class AgencyChannelDataController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyChannelDataController.class);
    @Autowired
    private AgencyChannelDataService agencyChannelDataService;

    @LogBefore(operType="/agencyChannelData/add", keyName="\u4ee3\u7406\u6e20\u9053\u6570\u636e\u6dfb\u52a0")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(@RequestBody AgencyChannelDataDTO agencyChannelDataDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            if (BeanValidator.validateGroup((Object)agencyChannelDataDto, (Class[])new Class[]{AgencyChannelDataDTO.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)agencyChannelDataDto, (Class[])new Class[]{AgencyChannelDataDTO.Add.class}).getMessage());
            }
            agencyChannelDataDto.setBelonger(user.getUsername());
            Long positionAssetSizeId = this.agencyChannelDataService.add(agencyChannelDataDto, user);
            return ResultModelFactory.SUCCESS((Serializable)positionAssetSizeId);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException) {
                return ResultModelFactory.FAIL500((String)(agencyChannelDataDto.getChannelNo() + "\u6536\u5165\u6570\u636e\u5df2\u5f55\u5165"));
            }
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519");
        }
    }

    @LogBefore(operType="/agencyChannelData/update", keyName="\u4ee3\u7406\u6e20\u9053\u6570\u636e\u66f4\u65b0")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(@RequestBody AgencyChannelDataDTO agencyChannelDataDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        if (agencyChannelDataDto == null || agencyChannelDataDto.getId() == null) {
            return ResultModelFactory.FAIL400((String)"\u4ee3\u7406\u6e20\u9053\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (BeanValidator.validateGroup((Object)agencyChannelDataDto, (Class[])new Class[]{AgencyChannelDataDTO.Update.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)agencyChannelDataDto, (Class[])new Class[]{AgencyChannelDataDTO.Update.class}).getMessage());
            }
            Integer result = this.agencyChannelDataService.update(agencyChannelDataDto, user);
            rs.setReturnValue((Object)result);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException) {
                return ResultModelFactory.FAIL500((String)(agencyChannelDataDto.getChannelNo() + "\u6536\u5165\u6570\u636e\u5df2\u5f55\u5165"));
            }
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/agencyChannelData/batchUpdate", keyName="\u4ee3\u7406\u6e20\u9053\u6570\u636e\u6279\u91cf\u66f4\u65b0")
    @RequestMapping(value={"/batchUpdate"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel batchUpdate(@RequestBody AgencyChannelDataBatchUpdateDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        try {
            if (BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{AgencyChannelDataDTO.Update.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{AgencyChannelDataDTO.Update.class}).getMessage());
            }
            if (dto.getValidClickPrice() == null && dto.getQualityFactor() == null && StringUtils.isBlank((CharSequence)dto.getRemark())) {
                return ResultModelFactory.FAIL400((String)"\u6279\u91cf\u4fee\u6539\u7684\u503c\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
            rs.setReturnValue((Object)this.agencyChannelDataService.batchUpdate(dto, user));
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/agencyChannelData/import", keyName="\u5bfc\u5165\u4ee3\u7406\u6e20\u9053\u6570\u636e")
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public ResultModel importData(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="file") MultipartFile file) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        try {
            ImportParams importParams = new ImportParams();
            importParams.setNeedVerfiy(true);
            ExcelImportResult importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), AgencyChannelDataImportExcelDTO.class, (ImportParams)importParams);
            List successList = importResult.getList();
            List failList = importResult.getFailList();
            if (CollectionUtils.isEmpty((Collection)successList) && CollectionUtils.isEmpty((Collection)failList)) {
                return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u5931\u8d25\u6570\u636e\u4e3a\u7a7a\u3002");
            }
            rs.setReturnValue((Object)this.agencyChannelDataService.importData(successList, user, failList));
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException) {
                return ResultModelFactory.FAIL500((String)"\u6587\u4ef6\u4e2d\u5df2\u6709\u6e20\u9053\u6536\u5165\u6570\u636e\u5f55\u5165");
            }
            return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519");
        }
        rs.setSuccessed(Boolean.TRUE.booleanValue());
        return rs;
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AgencyChannelData>> findAll(HttpServletRequest request, HttpServletResponse response, AgencyChannelDataSearchDTO searchDto) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.agencyChannelDataService.findAll(searchDto, user);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/agencyChannelData/delete", keyName="\u4ee3\u7406\u6e20\u9053\u6570\u636e\u5220\u9664")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="ids") List<Long> ids) {
        User user = this.getUser(request, response);
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.agencyChannelDataService.delete(ids, user));
            resultModel.setSuccessed(Boolean.TRUE.booleanValue());
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u5220\u9664\u5931\u8d25");
        }
        return resultModel;
    }

    @LogBefore(operType="/agencyChannelData/pushDataToCms", keyName="\u63a8\u9001\u6570\u636e\u5230CMS\u540e\u53f0")
    @RequestMapping(value={"/pushDataToCms"}, method={RequestMethod.POST})
    public ResultModel pushDataToCms(HttpServletRequest request, HttpServletResponse response, @Validated @RequestBody AgencyChannelDataSyncDTO dto) {
        User user = this.getUser(request, response);
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setSuccessed(this.agencyChannelDataService.pushDataToCms(dto, user));
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u63a8\u9001\u6570\u636e\u5230CMS\u540e\u53f0\u5f02\u5e38\uff1a" + ExceptionUtils.getStackTrace((Throwable)e));
            return ResultModelFactory.FAIL500((String)"\u63a8\u9001\u6570\u636e\u5230CMS\u540e\u53f0\u5f02\u5e38");
        }
        return resultModel;
    }
}

