/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.agencychannel;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.ProxyChannelDataBatchUpdateDTO;
import com.bxm.adsmanager.model.dto.ProxyChannelDataDTO;
import com.bxm.adsmanager.model.dto.ProxyChannelDataImportExcelDTO;
import com.bxm.adsmanager.model.dto.ProxyChannelDataSearchDTO;
import com.bxm.adsmanager.model.vo.ProxyChannelDataVO;
import com.bxm.adsmanager.service.agencychannel.ProxyChannelDataService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/proxyChannelData"})
public class ProxyChannelDataController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyChannelDataController.class);
    @Autowired
    private ProxyChannelDataService proxyChannelDataService;

    @LogBefore(operType="/proxyChannelData/update", keyName="\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u66f4\u65b0")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(@RequestBody ProxyChannelDataDTO proxyChannelDataDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        this.testFillRole(user);
        try {
            if (BeanValidator.validateGroup((Object)proxyChannelDataDto, (Class[])new Class[]{ProxyChannelDataDTO.Update.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)proxyChannelDataDto, (Class[])new Class[]{ProxyChannelDataDTO.Update.class}).getMessage());
            }
            this.proxyChannelDataService.update(proxyChannelDataDto, user);
            rs.setReturnValue((Object)Boolean.TRUE);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/proxyChannelData/empty", keyName="\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u6e05\u7a7a")
    @RequestMapping(value={"/empty"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel empty(@RequestBody ProxyChannelDataDTO proxyChannelDataDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        this.testFillRole(user);
        try {
            if (BeanValidator.validateGroup((Object)proxyChannelDataDto, (Class[])new Class[]{ProxyChannelDataDTO.Empty.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)proxyChannelDataDto, (Class[])new Class[]{ProxyChannelDataDTO.Empty.class}).getMessage());
            }
            for (Long id : proxyChannelDataDto.getIds()) {
                proxyChannelDataDto.setId(id);
                this.proxyChannelDataService.update(proxyChannelDataDto, user);
            }
            rs.setReturnValue((Object)Boolean.TRUE);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u6e05\u7a7a\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6e05\u7a7a\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/proxyChannelData/batchUpdate", keyName="\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u6279\u91cf\u66f4\u65b0")
    @RequestMapping(value={"/batchUpdate"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel batchUpdate(@RequestBody ProxyChannelDataBatchUpdateDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        this.testFillRole(user);
        try {
            if (BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{ProxyChannelDataBatchUpdateDTO.Update.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{ProxyChannelDataBatchUpdateDTO.Update.class}).getMessage());
            }
            if (dto.getDs() == null && dto.getDsPrice() == null) {
                return ResultModelFactory.FAIL400((String)"\u6279\u91cf\u4fee\u6539\u7684\u503c\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
            rs.setReturnValue((Object)this.proxyChannelDataService.batchUpdate(dto, user));
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/proxyChannelData/import", keyName="\u5bfc\u5165\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09")
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public ResultModel<String> importData(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="file") MultipartFile file) {
        User user = this.getUser(request, response);
        try {
            ImportParams importParams = new ImportParams();
            importParams.setNeedVerfiy(true);
            ExcelImportResult importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), ProxyChannelDataImportExcelDTO.class, (ImportParams)importParams);
            List successList = importResult.getList();
            List failList = importResult.getFailList();
            if (CollectionUtils.isEmpty((Collection)successList) && CollectionUtils.isEmpty((Collection)failList)) {
                return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff1a\u6570\u636e\u4e3a\u7a7a\u3002");
            }
            this.proxyChannelDataService.importData(successList, user, failList);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519" + e.getMessage(), (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException) {
                return ResultModelFactory.FAIL500((String)"\u6587\u4ef6\u4e2d\u5df2\u6709\u6e20\u9053\u6536\u5165\u6570\u636e\u5f55\u5165");
            }
            return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519");
        }
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<ProxyChannelDataVO>> findAll(HttpServletRequest request, HttpServletResponse response, ProxyChannelDataSearchDTO searchDto) {
        this.checkDate(searchDto.getStartTime(), searchDto.getEndTime(), 31);
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        try {
            this.testFillRole(user);
            PageInfo result = this.proxyChannelDataService.findAll(searchDto, user);
            rs.setReturnValue((Object)result);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519");
        }
        return rs;
    }

    private void testFillRole(User user) {
    }

    private void checkDate(String startTime, String endTime, int days) {
        Date sdate = DateUtil.convertStr2Date((String)startTime);
        Date edate = DateUtil.convertStr2Date((String)endTime);
        if ((sdate = DateUtil.increaseDate((Date)sdate, (int)days)).getTime() < edate.getTime()) {
            throw new BusinessException("\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc7 " + days + " \u5929");
        }
    }

    @RequestMapping(value={"/template"}, method={RequestMethod.GET})
    public void export(HttpServletRequest request, HttpServletResponse response, ProxyChannelDataSearchDTO searchDto) {
        this.checkDate(searchDto.getStartTime(), searchDto.getEndTime(), 7);
        try {
            User user = this.getUser(request, response);
            List<ProxyChannelDataVO> exportList = this.proxyChannelDataService.getList(searchDto, user);
            if (CollectionUtils.isEmpty((Collection)exportList)) {
                exportList = Collections.emptyList();
            }
            for (ProxyChannelDataVO proxyChannelDataVO : exportList) {
                proxyChannelDataVO.setDsCpsBrokerage(null);
                proxyChannelDataVO.setDsIncome(null);
                proxyChannelDataVO.setDsPrice(null);
                proxyChannelDataVO.setDsValidClick(null);
            }
            ExcelUtil.exportExcel(exportList, null, null, ProxyChannelDataVO.class, (String)"\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u8bb0\u5f55\u5bfc\u51fa.xls", (HttpServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5bfc\u51fa\u4ee3\u7406\u6570\u636e\uff08\u4e0b\u6e38\uff09\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
    }
}

