/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketTagConfMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dto.AdAuditRecordDto;
import com.bxm.adsmanager.model.vo.AdAuditRecordVo;
import com.bxm.adsmanager.service.audit.AdAuditRecordService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/audit/record"})
public class AdAuditRecordController {
    @Autowired
    private AdAuditRecordService adAuditRecordService;
    @Autowired
    private AdTicketTagConfMapper adTicketTagConfMapper;

    @GetMapping(value={"/getPage"})
    public ResultModel<PageInfo<AdAuditRecordVo>> getPage(AdAuditRecordDto adAuditRecordDto) {
        if (null != adAuditRecordDto.getTag()) {
            ArrayList targetTagTicketIds = this.adTicketTagConfMapper.findTicketIdByTagCode(adAuditRecordDto.getTag());
            if (targetTagTicketIds == null) {
                targetTagTicketIds = new ArrayList();
            }
            adAuditRecordDto.setTicketIds((List)targetTagTicketIds);
        }
        if (StringUtils.isNotBlank((String)adAuditRecordDto.getStartTime()) && StringUtils.isNotBlank((String)adAuditRecordDto.getEndTime())) {
            adAuditRecordDto.setStartTime(adAuditRecordDto.getStartTime() + " 00:00:00");
            adAuditRecordDto.setEndTime(adAuditRecordDto.getEndTime() + " 23:59:59");
        }
        PageInfo pageInfo = this.adAuditRecordService.getPage(adAuditRecordDto);
        return ResultModelFactory.SUCCESS((Serializable)pageInfo);
    }

    @GetMapping(value={"/export"})
    public ResultModel<PageInfo<AdAuditRecordVo>> export(AdAuditRecordDto adAuditRecordDto, HttpServletResponse response) {
        adAuditRecordDto.setPageNum(Integer.valueOf(1));
        adAuditRecordDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        if (null != adAuditRecordDto.getTag()) {
            ArrayList targetTagTicketIds = this.adTicketTagConfMapper.findTicketIdByTagCode(adAuditRecordDto.getTag());
            if (targetTagTicketIds == null) {
                targetTagTicketIds = new ArrayList();
            }
            adAuditRecordDto.setTicketIds((List)targetTagTicketIds);
        }
        String exportStartDate = adAuditRecordDto.getStartTime();
        String exportEndDate = adAuditRecordDto.getEndTime();
        if (StringUtils.isNotBlank((String)adAuditRecordDto.getStartTime()) && StringUtils.isNotBlank((String)adAuditRecordDto.getEndTime())) {
            adAuditRecordDto.setStartTime(adAuditRecordDto.getStartTime() + " 00:00:00");
            adAuditRecordDto.setEndTime(adAuditRecordDto.getEndTime() + " 23:59:59");
        }
        PageInfo pageInfo = this.adAuditRecordService.getPage(adAuditRecordDto);
        List list = pageInfo.getList();
        String dateFormat = "yyyy-MM-dd HH:mm:ss";
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.stream().forEach(l -> {
                l.setAuditTimeStr(l.getAuditTime());
                l.setSubmitTimeStr(l.getSubmitTime());
                l.setTicketTypeStr(AdTicket.AdTicketType.getName((short)l.getTicketType()));
                if (l.getTicketAuditStatus() != null) {
                    l.setTicketAuditStatusStr(l.getTicketAuditStatus() == 1 ? "\u901a\u8fc7" : "\u62d2\u7edd");
                }
                if (l.getAssetsAuditStatus() != null) {
                    l.setAssetsAuditStatusStr(l.getAssetsAuditStatus() == 1 ? "\u901a\u8fc7" : "\u62d2\u7edd");
                }
            });
        }
        ExcelUtil.exportExcel((List)pageInfo.getList(), null, (String)"\u5ba1\u6838\u65e5\u5fd7", AdAuditRecordVo.class, (String)("\u5ba1\u6838\u65e5\u5fd7" + exportStartDate + "-" + exportEndDate + ".xls"), (HttpServletResponse)response);
        return ResultModelFactory.SUCCESS((Serializable)pageInfo);
    }

    public static void main(String[] args) {
        System.out.println(new DateTime((Object)"2022-04-30"));
    }
}

