/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.model.vo.audit.QualificationConfigVo;
import com.bxm.adsmanager.service.audit.QualificationService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/audit"})
public class QualificationController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(QualificationController.class);
    @Autowired
    QualificationService qualificationService;

    @RequestMapping(value={"/qualification/add"}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="name") String name, @RequestParam(value="grade") Short grade, @RequestParam(value="parentId") Long parentId, @RequestParam(value="remark", required=false) String remark, @RequestParam(value="code", required=true) Integer code) {
        try {
            String userName = this.getUser(request, response).getUsername();
            return this.qualificationService.add(name, grade, parentId, remark, userName, code);
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u8d44\u8d28\u83dc\u5355\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/qualification/update"}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="name") String name, @RequestParam(value="id") Long id, @RequestParam(value="remark", required=false) String remark, @RequestParam(value="code", required=true) Integer code) {
        try {
            String userName = this.getUser(request, response).getUsername();
            return this.qualificationService.update(name, id, remark, userName, code);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u8d44\u8d28\u83dc\u5355\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/qualification/delete"}, produces={"application/json"})
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Long id) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.qualificationService.delete(id, userName);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u8d44\u8d28\u83dc\u5355\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/qualification/getPageList"}, produces={"application/json"})
    public ResultModel<PageInfo<QualificationConfigVo>> getPageList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="status", required=false) String status, @RequestParam(value="grade", required=false) String grade, @RequestParam(value="parentId", required=false) String parentId) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.qualificationService.getPageList(grade, keywords, status, pageNum, pageSize, parentId));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u8d44\u8d28\u83dc\u5355\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u8d44\u8d28\u83dc\u5355\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }

    @RequestMapping(value={"/qualification/getList"}, produces={"application/json"})
    public ResultModel<List<QualificationConfigVo>> getList(@RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="status", required=false) String status, @RequestParam(value="grade", required=false) String grade, @RequestParam(value="parentId", required=false) String parentId) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.qualificationService.getList(grade, keywords, status, parentId));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u8d44\u8d28\u83dc\u5355\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u8d44\u8d28\u83dc\u5355\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }
}

