/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.facade.model.video.VideoAssetDto;
import com.bxm.adsmanager.facade.model.video.VideoAssetVo;
import com.bxm.adsmanager.service.audit.VideoAssetService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/video"})
public class VideoAssetController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoAssetController.class);
    @Autowired
    VideoAssetService videoAssetService;

    @RequestMapping(value={"/asset/saveOrUpdate"}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, VideoAssetDto videoAssetDto) {
        try {
            String userName = this.getUser(request, response).getUsername();
            videoAssetDto.setCreateUser(userName);
            this.videoAssetService.add(videoAssetDto);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u6216\u8005\u4fee\u6539\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/asset/updateStatus"}, produces={"application/json"})
    public ResultModel updateStatus(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="status") Short status, @RequestParam(value="id") Long id) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.videoAssetService.updateStatus(id, status, userName);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u72b6\u6001\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/asset/getVideoAssetVo"}, produces={"application/json"})
    public ResultModel<VideoAssetVo> getVideoAssetVo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Long id) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.videoAssetService.getVideoAssetVo(id, null));
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u72b6\u6001\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/asset/getList"}, produces={"application/json"})
    public ResultModel<PageInfo<VideoAssetVo>> getList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(value="keywords", required=false) String keywords) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.videoAssetService.getList(keywords, pageNum, pageSize));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }

    @RequestMapping(value={"/asset/download"}, produces={"application/json"})
    public void download(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Long id) {
        try {
            String url = this.videoAssetService.url(id);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                VideoAssetController.saveImg(url, response);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u62d2\u7edd\u539f\u56e0\u5217\u8868\u51fa\u9519", (Object)e.getMessage());
        }
    }

    public static void saveImg(String imgUrl, HttpServletResponse response) {
        try {
            URL url = new URL(imgUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(2000);
            InputStream inStream = conn.getInputStream();
            byte[] data = VideoAssetController.readInputStream(inStream);
            String fileName = VideoAssetController.getImgFileName(imgUrl);
            response.setHeader("Content-disposition", "attachment;filename= " + fileName);
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(data);
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u51fa\u9519", (Object)e.getMessage());
        }
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    public static String getImgPath(String imgUrl) {
        return imgUrl.substring(imgUrl.indexOf("n/") + 1, imgUrl.lastIndexOf("/"));
    }

    public static String getImgFileName(String imgUrl) {
        return imgUrl.substring(imgUrl.lastIndexOf("/") + 1);
    }
}

