/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.common;

import com.bxm.adsmanager.dal.mapper.rtb.PositionRtbMapper;
import com.bxm.adsmanager.dal.mapper.rtb.RtbCvrControlMapper;
import com.bxm.adsmanager.dal.mapper.rtb.RtbRatioControlMapper;
import com.bxm.adsmanager.integration.adsmedia.appentrance.InspireVideoFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.media.MediaCommonConfigFacadeIntegration;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannel;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AgencyChannelDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelSearchDTO;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.media.MediaTicketVo;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmanager.service.agencychannel.AgencyChannelService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.media.MediaTicketTagService;
import com.bxm.adsmanager.service.rtb.PositionRTBService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeDto;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeRo;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common"})
public class MediaCommonController {
    private static final Logger log = LoggerFactory.getLogger(MediaCommonController.class);
    @Autowired
    private MediaCommonConfigFacadeIntegration mediaCommonConfigFacadeIntegration;
    @Autowired
    private InspireVideoFacadeIntegration inspireVideoFacadeIntegration;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private AdPositionAuditService adPositionAuditService;
    @Autowired
    private MediaTicketTagService mediaTicketTagService;
    @Autowired
    private AgencyChannelService agencyChannelService;
    @Autowired
    private PositionRtbMapper positionRtbMapper;
    @Autowired
    private RtbRatioControlMapper rtbRatioControlMapper;
    @Autowired
    private RtbCvrControlMapper rtbCvrControlMapper;
    @Autowired
    private PositionRTBService positionRTBService;

    @RequestMapping(value={"/mediaConfigList"}, method={RequestMethod.GET})
    public ResultModel<List<PositionClassTypeRo>> queryPositionClassTypeList(@RequestParam(value="parentId", required=false, defaultValue="0") Long parentId, @RequestParam(value="typeCode") String typeCode, @RequestParam(value="name", required=false) String name) {
        PositionClassTypeDto param = new PositionClassTypeDto();
        param.setParentId(parentId);
        param.setTypeCode(typeCode);
        param.setName(name);
        return this.mediaCommonConfigFacadeIntegration.queryPositionClassTypeList(param);
    }

    @RequestMapping(value={"/updateAppEntranceData"}, method={RequestMethod.GET})
    public ResultModel<Boolean> updateAppEntranceData() {
        return this.inspireVideoFacadeIntegration.updateAppEntranceData("bxm_channel");
    }

    @RequestMapping(value={"/findTicketByParam"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<PageInfo<MediaTicketVo>> findTicketByParam(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="ids", required=false) String ids, @RequestParam(value="type", required=true, defaultValue="1") String type, @RequestParam(value="parentId", required=false) String parentId, @RequestParam(value="childId", required=false) String childId, @RequestParam(value="statusCode", required=false) String statusCode, @RequestParam(value="positionId", required=false) String positionId) throws Exception {
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.mediaTicketTagService.findTicketByParam(keywords, pageNum, pageSize, ids, type, parentId, statusCode, positionId, childId);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
        }
        catch (Exception e) {
            log.error("\u5a92\u4f53\u67e5\u627e\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519:" + e.getMessage() + ",queryString=" + request.getQueryString(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/updateAgencyChannelInfo"}, method={RequestMethod.GET})
    public ResultModel<Boolean> updateAgencyChannelInfo() {
        ResultModel rs = new ResultModel();
        HashSet<Long> ids = new HashSet<Long>();
        try {
            AgencyChannelSearchDTO searchDto = new AgencyChannelSearchDTO();
            searchDto.setProductName("\u6dd8\u5b9d");
            List all = this.agencyChannelService.getList(searchDto);
            if (CollectionUtils.isNotEmpty((Collection)all)) {
                for (AgencyChannel agencyChannel : all) {
                    String linkUrl = agencyChannel.getLinkUrl();
                    if (linkUrl.contains("1763656536")) {
                        agencyChannel.setProductName("\u6dd8\u5b9d-\u7559\u5b58\uff08\u5929\u5929\u7279\u5356\uff09");
                    } else if (linkUrl.contains("2089633783")) {
                        agencyChannel.setProductName("\u6dd8\u5b9d-\u4fc3\u6d3b\u5b9a\u5411\uff08ROI\uff09");
                    } else if (linkUrl.contains("1981891941")) {
                        agencyChannel.setProductName("\u6dd8\u5b9d-\u4fc3\u6d3b\u4f18\u9009");
                    } else if (linkUrl.contains("32896")) {
                        agencyChannel.setProductName("\u6dd8\u5b9d-\u4fc3\u6d3b\u5b9a\u5411");
                    } else if (linkUrl.contains("32768")) {
                        agencyChannel.setProductName("\u6dd8\u5b9d-\u4fc3\u6d3b\u901a\u6295");
                    } else {
                        log.info(String.valueOf(agencyChannel.getId()));
                        continue;
                    }
                    ids.add(agencyChannel.getId());
                    AgencyChannelDTO agencyChannelDTO = new AgencyChannelDTO();
                    BeanUtils.copyProperties((Object)agencyChannel, (Object)agencyChannelDTO);
                    User user = new User();
                    user.setRoleCodes((List)Lists.newArrayList((Object[])new String[]{RoleEnum.CHAN_PIN_LEADER.getCode()}));
                    this.agencyChannelService.update(agencyChannelDTO, user);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        rs.setReturnValue(ids);
        return rs;
    }

    @RequestMapping(value={"/updateAgencyChannelMd5Info"}, method={RequestMethod.GET})
    public ResultModel<Boolean> updateAgencyChannelMd5Info() {
        ResultModel rs = new ResultModel();
        HashSet<Long> ids = new HashSet<Long>();
        try {
            AgencyChannelSearchDTO searchDto = new AgencyChannelSearchDTO();
            List all = this.agencyChannelService.getList(searchDto);
            if (CollectionUtils.isNotEmpty((Collection)all)) {
                for (AgencyChannel agencyChannel : all) {
                    ids.add(agencyChannel.getId());
                    AgencyChannelDTO agencyChannelDTO = new AgencyChannelDTO();
                    BeanUtils.copyProperties((Object)agencyChannel, (Object)agencyChannelDTO);
                    User user = new User();
                    user.setRoleCodes((List)Lists.newArrayList((Object[])new String[]{RoleEnum.CHAN_PIN_LEADER.getCode()}));
                    this.agencyChannelService.update(agencyChannelDTO, user);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        rs.setReturnValue(ids);
        return rs;
    }
}

