/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.common;

import com.bxm.adsmanager.model.dto.InfoMediaMsgDto;
import com.bxm.adsmanager.model.dto.InfoPositionMsgDto;
import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.service.common.MediaPositionService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mediaPosition"})
@RestController
public class MediaPositionController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionController.class);
    @Autowired
    private MediaPositionService mediaPositionService;

    @RequestMapping(value={"/findMediaByRole"}, method={RequestMethod.GET})
    public ResultModel<List<InfoMediaMsgDto>> findMediaByRole(CommonSearchDto search, HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.mediaPositionService.findMediaByRole(this.getUser(request, response), search));
        }
        catch (Exception e) {
            LOGGER.error("\u5a92\u4f53\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5a92\u4f53\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findPositionByRole"}, method={RequestMethod.GET})
    public ResultModel<List<InfoPositionMsgDto>> findPositionByRole(CommonSearchDto search, HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.mediaPositionService.findPositionByRole(this.getUser(request, response), search));
        }
        catch (Exception e) {
            LOGGER.error("\u5a92\u4f53\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5a92\u4f53\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findMediaAll"}, method={RequestMethod.GET})
    public ResultModel<List<InfoMediaMsgDto>> findMediaAll(CommonSearchDto search) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.mediaPositionService.findMediaAll(search));
        }
        catch (Exception e) {
            LOGGER.error("\u5a92\u4f53\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5a92\u4f53\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findPositionAll"}, method={RequestMethod.GET})
    public ResultModel<List<InfoPositionMsgDto>> findPositionAll(CommonSearchDto search) {
        ResultModel rs = new ResultModel();
        try {
            if (StringUtils.isEmpty((CharSequence)search.getAppKey())) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u8be2\u7684\u5e7f\u544a\u4f4d");
                return rs;
            }
            rs.setReturnValue((Object)this.mediaPositionService.findPositionAll(search));
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u544a\u4f4d\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5e7f\u544a\u4f4d\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findPositionAll2"}, method={RequestMethod.GET})
    public ResultModel<List<InfoPositionMsgDto>> findPositionAll(String appKeys, String keyWords) {
        ResultModel rs = new ResultModel();
        try {
            List<Object> appKeyList = null;
            if (StringUtils.isNotBlank((CharSequence)appKeys)) {
                String[] appKeysArray = appKeys.split(",");
                if (appKeysArray.length > 0) {
                    appKeyList = Arrays.asList(appKeysArray);
                }
            } else {
                appKeyList = Collections.emptyList();
            }
            rs.setReturnValue((Object)this.mediaPositionService.findAllPositionByAppkeysAndKeywords(appKeyList, keyWords));
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u544a\u4f4d\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5e7f\u544a\u4f4d\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findPositionAllByparam"}, method={RequestMethod.GET})
    public ResultModel<List<InfoPositionMsgDto>> findPositionAllList(CommonSearchDto search) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.mediaPositionService.findPositionAll(search));
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u544a\u4f4d\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5e7f\u544a\u4f4d\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }
}

