/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.diysite;

import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.diysite.SiteInstanceDto;
import com.bxm.adsmanager.model.dao.diysite.SiteTemplateDto;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.diysite.SiteInstanceService;
import com.bxm.adsmanager.service.diysite.SiteTemplateService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/diysite"})
public class DIYSiteContoller
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DIYSiteContoller.class);
    @Autowired
    private SiteTemplateService siteTemplateService;
    @Autowired
    private SiteInstanceService siteInstanceService;

    @RequestMapping(value={"/getTemplates"})
    public ResultModel getTemplates(SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        try {
            Map all = this.siteTemplateService.findAll(dto);
            rs.setReturnValue((Object)all);
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("getTemplates Error", (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/findAllTemplate"}, method={RequestMethod.GET})
    public ResultModel findAllTemplate(SiteTemplateDto dto) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo all = this.siteTemplateService.findTemplate(dto);
            rs.setReturnValue((Object)all);
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("findAllTemplate Error", (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/findAll"})
    public ResultModel findAll(SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo all = this.siteInstanceService.findAll(dto);
            rs.setReturnValue((Object)all);
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("findAll Error", (Throwable)e);
        }
        return rs;
    }

    @LogBefore(operType="/diysite/add", keyName="\u65b0\u589e\u81ea\u5efa\u7ad9")
    @RequestMapping(value={"/add"}, produces={"application/json"})
    public ResultModel add(SiteInstanceDto dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        dto.setId(null);
        try {
            rs.setReturnValue((Object)this.siteInstanceService.saveOrUpdate(dto, user));
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("add Error", (Throwable)e);
        }
        return rs;
    }

    @LogBefore(operType="/diysite/update", keyName="\u66f4\u65b0\u81ea\u5efa\u7ad9")
    @RequestMapping(value={"/update"}, produces={"application/json"})
    public ResultModel update(SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.siteInstanceService.saveOrUpdate(dto, null));
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("update Error", (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/get"})
    public ResultModel get(SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        if (null == dto || null == dto.getId() || dto.getId() <= 0L) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
            rs.setErrorDesc("id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            return rs;
        }
        try {
            rs.setReturnValue((Object)this.siteInstanceService.getById(dto.getId()));
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("update Error", (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/delete"})
    public ResultModel delete(SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        if (null == dto || null == dto.getId() || dto.getId() <= 0L) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
            rs.setErrorDesc("id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            return rs;
        }
        try {
            rs.setReturnValue((Object)this.siteInstanceService.deleteById(dto.getId()));
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("update Error", (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/findCreateUser"})
    public ResultModel<List<Dictionaries>> findCreateUser() {
        ResultModel resultModel = new ResultModel();
        List list = this.siteInstanceService.findCreateUser();
        resultModel.setReturnValue((Object)list);
        return resultModel;
    }
}

