/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.exclude;

import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitMediaDto;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitPositionDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitMediaVo;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitPositionVo;
import com.bxm.adsmanager.service.adprofit.AdProfitMediaPositionService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ExcelUtils;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.ExcludeBaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/exclude"})
public class ExcludeExcelController
extends ExcludeBaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcludeExcelController.class);
    private static final int DEFULT_ONE = 1;
    @Autowired
    private AdProfitMediaPositionService adProfitMediaPositionService;

    @LogBefore(keyName="\u5e7f\u544a", operType="/exclude/downLoadMedia")
    @RequestMapping(value={"/downLoadMedia"}, method={RequestMethod.GET})
    public ResultModel downLoadMediaExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="datetime") String datetime, @RequestParam(required=true, name="token") String token) {
        try {
            boolean result = this.auth(request, response, token);
            if (!result) {
                return ResultModelFactory.FAIL400((String)"\u7528\u6237\u6ca1\u6709\u6743\u9650");
            }
            List list = this.adProfitMediaPositionService.downLoadMedia(datetime);
            ExcelUtil.exportExcel((List)list, null, (String)"\u5a92\u4f53\u6536\u76ca", AdProfitMediaVo.class, (String)("\u5a92\u4f53\u6536\u76ca" + datetime + ".xls"), (HttpServletResponse)response);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4e0b\u8f7d\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(keyName="\u5e7f\u544a", operType="/exclude/downLoadPosition")
    @RequestMapping(value={"/downLoadPosition"}, method={RequestMethod.GET})
    public ResultModel downLoadPositionExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="datetime") String datetime, @RequestParam(required=false, name="appId") String appId, @RequestParam(required=true, name="token") String token) {
        try {
            boolean result = this.auth(request, response, token);
            if (!result) {
                return ResultModelFactory.FAIL400((String)"\u7528\u6237\u6ca1\u6709\u6743\u9650");
            }
            List list = this.adProfitMediaPositionService.downLoadPosition(datetime, appId);
            ExcelUtil.exportExcel((List)list, null, (String)"\u5e7f\u544a\u4f4d\u6536\u76ca", AdProfitPositionVo.class, (String)("\u5e7f\u544a\u4f4d\u6536\u76ca" + datetime + ".xls"), (HttpServletResponse)response);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u5e7f\u544a\u4f4d\u6536\u76caExcel\u8868\u683c\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4e0b\u8f7d\u5e7f\u544a\u4f4d\u6536\u76caExcel\u8868\u683c\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(keyName="\u5e7f\u544a", operType="/exclude/importProfit")
    @RequestMapping(value={"/importProfit"}, method={RequestMethod.POST})
    public ResultModel<Pagination> importProfitExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="token") String token) {
        try {
            boolean result = this.auth(request, response, token);
            if (!result) {
                return ResultModelFactory.FAIL400((String)"\u7528\u6237\u6ca1\u6709\u6743\u9650");
            }
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            User user = this.getUser(request, response);
            Iterator iterator = fileMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entity = iterator.next();
                MultipartFile file = (MultipartFile)entity.getValue();
                String originalFilename = file.getOriginalFilename();
                if (originalFilename.indexOf("\u5a92\u4f53\u6536\u76ca") != -1) {
                    LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
                    fieldMap.put("ID", "id");
                    fieldMap.put("\u65e5\u671f", "datetime");
                    fieldMap.put("\u5a92\u4f53ID", "appId");
                    fieldMap.put("\u9884\u4f30\u6536\u76ca", "profitPredict");
                    fieldMap.put("\u5b9e\u9645\u6536\u76ca", "profitActual");
                    fieldMap.put("\u5907\u6ce8", "remark");
                    List results = ExcelUtils.excelToList((InputStream)file.getInputStream(), (String)"\u5a92\u4f53\u6536\u76ca", AdProfitMediaDto.class, fieldMap, (int)1);
                    this.adProfitMediaPositionService.importProfitMediaExcel(user, results);
                    return ResultModelFactory.SUCCESS();
                }
                if (originalFilename.indexOf("\u5e7f\u544a\u4f4d\u6536\u76ca") != -1) {
                    LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
                    fieldMap.put("ID", "id");
                    fieldMap.put("\u65e5\u671f", "datetime");
                    fieldMap.put("\u5e7f\u544a\u4f4dID", "positionId");
                    fieldMap.put("\u5a92\u4f53ID", "appId");
                    fieldMap.put("\u9884\u4f30\u6536\u76ca", "profitPredict");
                    fieldMap.put("\u6263\u91cf\u91d1\u989d", "profitDeduct");
                    fieldMap.put("\u5907\u6ce8", "remark");
                    List results = ExcelUtils.excelToList((InputStream)file.getInputStream(), (String)"\u5e7f\u544a\u4f4d\u6536\u76ca", AdProfitPositionDto.class, fieldMap, (int)1);
                    this.adProfitMediaPositionService.importAdProfitPositionExcel(user, results);
                    return ResultModelFactory.SUCCESS();
                }
                return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u5931\u8d25(\u8868\u683c\u540d\u79f0\u4e0d\u8bc6\u522b)");
            }
        }
        catch (ProfitException pe) {
            return ResultModelFactory.FAIL500((String)pe.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(keyName="\u5e7f\u544a", operType="/exclude/importProfitExcelTest")
    @RequestMapping(value={"/importProfitExcelTest"}, method={RequestMethod.POST})
    public ResultModel<Pagination> importProfitExcelTest(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="token") String token) {
        try {
            boolean result = this.auth(request, response, token);
            if (!result) {
                return ResultModelFactory.FAIL400((String)"\u7528\u6237\u6ca1\u6709\u6743\u9650");
            }
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            User user = this.getUser(request, response);
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile file = (MultipartFile)entity.getValue();
                String originalFilename = file.getOriginalFilename();
                if (originalFilename.indexOf("\u5a92\u4f53\u6536\u76ca") == -1) continue;
                LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
                fieldMap.put("ID", "id");
                fieldMap.put("\u65e5\u671f", "datetime");
                fieldMap.put("\u5a92\u4f53ID", "appId");
                fieldMap.put("\u9884\u4f30\u6536\u76ca", "profitPredict");
                fieldMap.put("\u5b9e\u9645\u6536\u76ca", "profitActual");
                fieldMap.put("\u5907\u6ce8", "remark");
                List results = ExcelUtils.excelToList((InputStream)file.getInputStream(), (String)"\u5a92\u4f53\u6536\u76ca", AdProfitMediaDto.class, fieldMap, (int)1);
                this.adProfitMediaPositionService.importAdProfitMediaExcel(user, results);
                return ResultModelFactory.SUCCESS();
            }
        }
        catch (ProfitException pe) {
            return ResultModelFactory.FAIL500((String)pe.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }
}

