/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.exclude;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.model.dao.position.PositionQualityFactor;
import com.bxm.adsmanager.service.position.PositionQualityFactorService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/exclude"})
public class ExcludePositionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcludePositionController.class);
    @Autowired
    private NewAppEntranceFacadeIntegration appEntranceFacadeIntegration;
    @Autowired
    private PositionQualityFactorService positionQualityFactorService;

    @LogBefore(keyName="\u5bfc\u5165\u5e7f\u544a\u4f4d\u8d28\u91cf\u56e0\u5b50", operType="/exclude/importPositionQualityFactor")
    @RequestMapping(value={"/importPositionQualityFactor"}, method={RequestMethod.POST})
    public ResultModel<String> importPositionQualityFactor(@RequestParam(value="file") MultipartFile file, @RequestParam(required=false, name="token") String token, HttpServletRequest request) {
        List list = null;
        ImportParams importParams = new ImportParams();
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), PositionQualityFactor.class, (ImportParams)importParams);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List<PositionQualityFactor> newList = this.dealImportData(list);
                Boolean flag = this.checkPositionQualityFactor(newList);
                if (!flag.booleanValue()) {
                    return ResultModelFactory.FAIL500((String)"\u5e7f\u544a\u4f4d\u4ee3\u53f7\u5b58\u5728\u91cd\u590d\u6570\u636e");
                }
                if (CollectionUtils.isNotEmpty(newList)) {
                    this.positionQualityFactorService.addPositionQualityFactorBatch(newList);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u8d28\u91cf\u56e0\u5b50Excel\u8868\u683c\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u8d28\u91cf\u56e0\u5b50Excel\u8868\u683c\u51fa\u9519");
        }
        return ResultModelFactory.SUCCESS();
    }

    @Deprecated
    private List<PositionQualityFactor> generateImportData(List<PositionQualityFactor> param) {
        if (!CollectionUtils.isEmpty(param)) {
            for (PositionQualityFactor record : param) {
                if (!StringUtils.isNotBlank((String)record.getAppKey()) || !StringUtils.isNotBlank((String)record.getBusiness())) continue;
                record.setPositionId(record.getAppKey() + "-" + record.getBusiness().replace("ad-", ""));
                record.setImportTime(DateUtil.dateTo8String((Date)DateUtil.increaseDate((Date)new Date(), (int)-1)));
            }
        }
        return param;
    }

    private List<PositionQualityFactor> dealImportData(List<PositionQualityFactor> param) {
        ArrayList<PositionQualityFactor> resultList = new ArrayList<PositionQualityFactor>();
        if (CollectionUtils.isNotEmpty(param)) {
            Map appEntranceCodeName = this.appEntranceFacadeIntegration.getAppEntranceCodeName();
            if (MapUtils.isEmpty((Map)appEntranceCodeName)) {
                appEntranceCodeName = Maps.newHashMap();
            }
            String importTime = DateUtil.dateTo8String((Date)DateUtil.increaseDate((Date)new Date(), (int)-1));
            for (PositionQualityFactor record : param) {
                if (StringUtils.isBlank((String)record.getFactor()) || StringUtils.isBlank((String)record.getPositionCode()) || !StringUtils.isNotBlank((String)record.getPositionCode())) continue;
                record.setPositionId((String)appEntranceCodeName.get(record.getPositionCode()));
                if (!StringUtils.isNotBlank((String)record.getPositionId())) continue;
                record.setImportTime(importTime);
                resultList.add(record);
            }
        }
        return resultList;
    }

    private Boolean checkPositionQualityFactor(List<PositionQualityFactor> list) {
        ArrayList positionIds = new ArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(positionQualityFactor -> {
                if (StringUtils.isNotBlank((String)positionQualityFactor.getPositionId())) {
                    positionIds.add(positionQualityFactor.getPositionId());
                }
            });
            return positionIds.size() == new HashSet(positionIds).size();
        }
        return true;
    }
}

