/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.model.dao.diysite.SiteInstanceDto;
import com.bxm.adsmanager.service.diysite.SiteInstanceService;
import com.bxm.adsmanager.service.diysite.SiteTemplateService;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertiser/diysite"})
public class AdvertiserDIYSiteController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserDIYSiteController.class);
    @Autowired
    private SiteTemplateService siteTemplateService;
    @Autowired
    private SiteInstanceService siteInstanceService;

    @RequestMapping(value={"/getTemplates"})
    public ResultModel getTemplates(@RequestBody SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        if (null == dto || null == dto.getAdvertiserId() || dto.getAdvertiserId() <= 0L) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
            rs.setErrorDesc("id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            return rs;
        }
        try {
            Map all = this.siteTemplateService.findAll(dto);
            rs.setReturnValue((Object)all);
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("getTemplates Error", (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/findAll"})
    public ResultModel findAll(@RequestBody SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo all = this.siteInstanceService.findAll(dto);
            rs.setReturnValue((Object)all);
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("findAll Error", (Throwable)e);
        }
        return rs;
    }

    @LogBefore(operType="/advertiser/diysite/add", keyName="\u65b0\u5efa\u81ea\u5efa\u7ad9")
    @RequestMapping(value={"/add"}, produces={"application/json"})
    public ResultModel add(@RequestBody SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.siteInstanceService.saveOrUpdate(dto, null));
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("add Error", (Throwable)e);
        }
        return rs;
    }

    @LogBefore(operType="/advertiser/diysite/update", keyName="\u66f4\u65b0\u81ea\u5efa\u7ad9")
    @RequestMapping(value={"/update"}, produces={"application/json"})
    public ResultModel update(@RequestBody SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.siteInstanceService.saveOrUpdate(dto, null));
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("update Error", (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/get"})
    public ResultModel get(@RequestBody SiteInstanceDto dto) {
        ResultModel rs = new ResultModel();
        if (null == dto || null == dto.getId() || dto.getId() <= 0L) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
            rs.setErrorDesc("id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            return rs;
        }
        try {
            rs.setReturnValue((Object)this.siteInstanceService.getById(dto.getId()));
        }
        catch (Exception e) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("update Error", (Throwable)e);
        }
        return rs;
    }
}

