/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.model.dao.audit.QualificationConfig;
import com.bxm.adsmanager.model.vo.audit.QualificationConfigVo;
import com.bxm.adsmanager.service.audit.QualificationService;
import com.bxm.util.dto.ResultModel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertiser"})
public class AdvertiserQualificationController {
    private static final Logger log = LoggerFactory.getLogger(AdvertiserQualificationController.class);
    @Autowired
    private QualificationService qualificationService;

    @RequestMapping(value={"/qualification/getList"}, produces={"application/json"})
    public ResultModel<List<QualificationConfigVo>> getList(@RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="status", required=false) String status, @RequestParam(value="grade", required=false) String grade, @RequestParam(value="parentId", required=false) String parentId) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.qualificationService.getList(grade, keywords, status, parentId));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u8d44\u8d28\u83dc\u5355\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u8d44\u8d28\u83dc\u5355\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }

    @RequestMapping(value={"/qualification/getAllList"}, produces={"application/json"})
    public ResultModel<List<QualificationConfig>> getAllList() {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.qualificationService.getAllList());
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u8d44\u8d28\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u8d44\u8d28\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }
}

