/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dto.TblAdQualifyDto;
import com.bxm.adsmanager.model.ro.QualifyContentRo;
import com.bxm.adsmanager.service.advertiser.AdvertiserQualifyService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertiser"})
public class AdvertiserQualifyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserQualifyController.class);
    @Autowired
    private AdvertiserQualifyService advertiserQualifyService;

    @RequestMapping(value={"/qualify"}, method={RequestMethod.POST})
    public ResultModel<Boolean> addQualify(@RequestBody String json) {
        ResultModel resultModel = new ResultModel();
        if (StringUtils.isBlank((String)json)) {
            return ResultModelFactory.FAIL500((String)"\u8d44\u8d28\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List list = JSON.parseArray((String)json, TblAdQualify.class);
            this.advertiserQualifyService.addAdvertiserQualifyBatch(list);
        }
        catch (BusinessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u8d44\u8d28\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            resultModel.setReturnValue((Object)false);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u6dfb\u52a0\u8d44\u8d28\u4fe1\u606f\u51fa\u9519");
            return resultModel;
        }
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    public static void main(String[] args) {
        QualifyContentRo qualifyContentRo1 = new QualifyContentRo();
        QualifyContentRo qualifyContentRo2 = new QualifyContentRo();
        QualifyContentRo qualifyContentRo3 = new QualifyContentRo();
        QualifyContentRo qualifyContentRo4 = new QualifyContentRo();
        ArrayList<QualifyContentRo> result = new ArrayList<QualifyContentRo>();
        qualifyContentRo1.setQualifyName("test1");
        qualifyContentRo1.setExpireTime("2022-02-18");
        qualifyContentRo1.setImages("www.baidu.com,www.baidu.com");
        qualifyContentRo1.setLongTime(false);
        qualifyContentRo2.setQualifyName("test1");
        qualifyContentRo2.setExpireTime("2022-02-18");
        qualifyContentRo2.setImages("www.baidu.com,www.baidu.com");
        qualifyContentRo2.setLongTime(false);
        qualifyContentRo3.setQualifyName("test1");
        qualifyContentRo3.setExpireTime("2022-02-18");
        qualifyContentRo3.setImages("www.baidu.com,www.baidu.com");
        qualifyContentRo3.setLongTime(false);
        qualifyContentRo4.setQualifyName("test1");
        qualifyContentRo4.setExpireTime("2022-02-18");
        qualifyContentRo4.setImages("www.baidu.com,www.baidu.com");
        qualifyContentRo4.setLongTime(false);
        result.add(qualifyContentRo1);
        result.add(qualifyContentRo2);
        result.add(qualifyContentRo3);
        result.add(qualifyContentRo4);
        System.out.println(JSON.toJSONString(result));
        String qualifyContent = JSON.toJSONString(result);
        TblAdQualify tblAdQualify = new TblAdQualify();
        tblAdQualify.setAdvertiserId(Long.valueOf(4902L));
        tblAdQualify.setQualifyName(Integer.valueOf(404));
        tblAdQualify.setContent("sfsdf");
        tblAdQualify.setQualifyContent(qualifyContent);
        ArrayList<TblAdQualify> tblAdQualifyList = new ArrayList<TblAdQualify>();
        tblAdQualifyList.add(tblAdQualify);
        System.out.println(JSON.toJSONString(tblAdQualifyList));
    }

    @RequestMapping(value={"/qualifyById"}, method={RequestMethod.GET})
    public ResultModel<TblAdQualify> getQualifyById(@RequestParam(name="id") Integer id) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.advertiserQualifyService.getAdQualifyById(id));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8d44\u8d28\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u8d44\u8d28\u4fe1\u606f\u51fa\u9519");
            return resultModel;
        }
        return resultModel;
    }

    @RequestMapping(value={"/updateQualify"}, method={RequestMethod.POST})
    public ResultModel<Boolean> updateQualifyById(@RequestBody TblAdQualify record) {
        ResultModel resultModel = new ResultModel();
        if (record == null || record.getId() == null) {
            return ResultModelFactory.FAIL500((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)record.getContent())) {
            return ResultModelFactory.FAIL400((String)"\u8bf7\u586b\u5199\u6295\u653e\u4ea7\u54c1\u540d\u79f0");
        }
        try {
            this.advertiserQualifyService.updateAdQualifyById(record);
        }
        catch (BusinessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u8d44\u8d28\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u66f4\u65b0\u8d44\u8d28\u4fe1\u606f\u51fa\u9519");
            return resultModel;
        }
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    @RequestMapping(value={"/getQualifyList"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<TblAdQualify>> getQualifyList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(name="auditStatus", required=false) Integer auditStatus, @RequestParam(value="advertiserIds", required=false) List<Long> advertiserIds, @RequestParam(value="advertiserId", required=false) Long advertiserId) {
        ResultModel resultModel = new ResultModel();
        TblAdQualifyDto param = new TblAdQualifyDto();
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);
        param.setAuditStatus(auditStatus);
        param.setAdvertiserList(advertiserIds);
        param.setAdvertiserId(advertiserId);
        try {
            resultModel.setReturnValue((Object)this.advertiserQualifyService.getAdQualifyList(param));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8d44\u8d28\u5217\u8868\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u8d44\u8d28\u5217\u8868\u4fe1\u606f\u51fa\u9519");
            return resultModel;
        }
        return resultModel;
    }

    @RequestMapping(value={"/getQualifyListByRequestBody"}, method={RequestMethod.POST})
    public ResultModel<PageInfo<TblAdQualify>> getQualifyListByRequestBody(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(name="auditStatus", required=false) Integer auditStatus, @RequestBody List<Long> advertiserIds, @RequestParam(name="content", required=false) String content) {
        ResultModel resultModel = new ResultModel();
        TblAdQualifyDto param = new TblAdQualifyDto();
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);
        param.setAuditStatus(auditStatus);
        param.setAdvertiserList(advertiserIds);
        param.setContent(content);
        try {
            resultModel.setReturnValue((Object)this.advertiserQualifyService.getAdQualifyList(param));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8d44\u8d28\u5217\u8868\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u8d44\u8d28\u5217\u8868\u4fe1\u606f\u51fa\u9519");
            return resultModel;
        }
        return resultModel;
    }
}

