/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketGetuiTagRef;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketUrlTest;
import com.bxm.adsmanager.model.dto.AdTicketDto;
import com.bxm.adsmanager.model.vo.AdFlowPackageNewVo;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowNewService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketOcpcService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adkeeper.TblAdTicketModifyService;
import com.bxm.adsmanager.service.role.RoleService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.commons.currency.Money;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.JsonHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertiser"})
public class AdvertiserTicketNewController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserTicketNewController.class);
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdTicketAssetsService adTicketAssetsService;
    @Autowired
    private AdTicketFlowNewService adTicketFlowNewService;
    @Autowired
    private TblAdTicketModifyService tblAdTicketModifyService;
    @Autowired
    private AdTicketOcpcService adTicketOcpcService;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private RoleService roleService;
    @Autowired
    private JedisUpdater jedisUpdater;

    @LogBefore(user="advertiser", operType="/addAdAssets", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/addAdAssets"}, method={RequestMethod.POST})
    public ResultModel<Long> addAssets(@RequestBody AdAssets adAssets) {
        ResultModel rs = new ResultModel();
        if (adAssets == null) {
            return ResultModelFactory.FAIL500((String)"\u53c2\u6570\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        try {
            rs = this.checkParam(rs, adAssets);
            if (!rs.isSuccessed()) {
                return rs;
            }
            Long id = this.adTicketAssetsService.add(adAssets);
            rs.setReturnValue((Object)id);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(user="advertiser", operType="/updateAdAssets", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/updateAdAssets"}, method={RequestMethod.POST})
    public ResultModel<String> updateAssets(@RequestBody AdAssets adAssets) {
        ResultModel rs = new ResultModel();
        if (adAssets == null || adAssets.getId() == null) {
            return ResultModelFactory.FAIL500((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String log = "";
        try {
            rs = this.checkParam(rs, adAssets);
            if (!rs.isSuccessed()) {
                return rs;
            }
            log = this.adTicketAssetsService.updateAndAudit(adAssets, null);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        rs.setReturnValue((Object)log);
        return rs;
    }

    @RequestMapping(value={"/queryAdvertiserByParam"}, method={RequestMethod.GET})
    public ResultModel<Long> queryAdvertiserByParam(HttpServletRequest request, @RequestParam(required=false, name="adAssetId") Long adAssetId, @RequestParam(required=false, name="ticketId") Long ticketId) {
        ResultModel rs = new ResultModel();
        if (adAssetId == null && ticketId == null) {
            return ResultModelFactory.FAIL500((String)"\u5165\u53c2\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        Long result = null;
        try {
            result = this.adTicketAssetsService.queryAdvertiserByParam(adAssetId, ticketId);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc("\u67e5\u627e\u5e7f\u544a\u5238\u5f02\u5e38");
            rs.setSuccessed(false);
            rs.setReturnValue((Object)result);
            return rs;
        }
        rs.setReturnValue((Object)result);
        return rs;
    }

    @LogBefore(user="advertiser", operType="/delAdAssets", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/delAdAssets"}, method={RequestMethod.DELETE})
    public ResultModel<Boolean> deleteAssets(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") String id) {
        ResultModel rs = new ResultModel();
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResultModelFactory.FAIL500((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.adTicketAssetsService.deleteAndAudit(id);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5e7f\u544a\u5238\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5220\u9664\u5e7f\u544a\u5238\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssets"}, method={RequestMethod.GET})
    public ResultModel<List<AdAssets>> findAllAssets(HttpServletRequest request, @RequestParam(required=true, name="ids") String ids) {
        ResultModel rs = new ResultModel();
        List list = null;
        try {
            list = this.adTicketAssetsService.findAll(ids);
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
            rs.setReturnValue(null);
            return rs;
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsByTicketId"}, method={RequestMethod.GET})
    public ResultModel<List<AdAssets>> findAllAssetsByTicketId(@RequestParam(required=true, name="ticketId") Long ticketId) {
        ResultModel rs = new ResultModel();
        List list = null;
        try {
            list = this.adTicketAssetsService.findAllAssetsById(ticketId);
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setReturnValue(null);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
            return rs;
        }
        return rs;
    }

    public <T> ResultModel checkParam(ResultModel<T> rs, AdAssets adAssets) {
        if (0 == adAssets.getVars() && StringUtil.isBlank((CharSequence)adAssets.getName())) {
            return ResultModelFactory.FAIL400((String)"\u4e0d\u663e\u793a\u7701\u5e02\u7684\u65f6\u5019name\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0 != adAssets.getVars() && StringUtil.isBlank((CharSequence)adAssets.getContent())) {
            return ResultModelFactory.FAIL400((String)"\u663e\u793a\u7701\u5e02\u7684\u65f6\u5019\u7d20\u6750\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BeanValidator.validateGroup((Object)adAssets, (Class[])new Class[]{AdAssets.Add.class}) != null) {
            return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adAssets, (Class[])new Class[]{AdAssets.Add.class}).getMessage());
        }
        return rs;
    }

    @LogBefore(user="advertiser", operType="/addTicket", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/addTicket"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<Long> addTicket(HttpServletRequest request, HttpServletResponse response, @RequestBody AdTicketDto adTicketDto) {
        ResultModel rs = new ResultModel();
        try {
            if (adTicketDto == null) {
                rs.setSuccessed(false);
                rs.setErrorDesc("\u63d0\u4ea4\u6570\u636e\u4e3a\u7a7a");
                return rs;
            }
            if (adTicketDto.getStatus() == null) {
                adTicketDto.setStatus(Short.valueOf((short)-2));
            }
            AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(adTicketDto.getAdvertiser().longValue());
            LOGGER.info(advertiserDto.getAe() + "------------------------------");
            adTicketDto.setAe(advertiserDto.getAe());
            if (StringUtil.isBlank((CharSequence)adTicketDto.getAe())) {
                List userName = this.roleService.getUserName("aeleader");
                adTicketDto.setAe((String)userName.get(0));
            }
            Long id = this.adTicketService.add(adTicketDto, adTicketDto.getCreateUser());
            try {
                if (id != null && adTicketDto.getAdvertiser() != null && RedisKeys.advertisers.contains(adTicketDto.getAdvertiser())) {
                    this.jedisUpdater.hupdate(RedisKeys.getPddTickets(), String.valueOf(id), (Object)adTicketDto.getAdvertiser());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u62fc\u591a\u591a\u5238\u5165Redis\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
            AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
            adTicketUrlTest.setTicketId(id);
            adTicketUrlTest.setActionType(Short.valueOf((short)0));
            adTicketUrlTest.setDealStatus(Short.valueOf((short)0));
            adTicketUrlTest.setCreateTime(new Date());
            adTicketUrlTest.setModifyTime(new Date());
            this.adTicketService.addTicketUrlTest(adTicketUrlTest);
            try {
                this.tblAdTicketModifyService.addLog(adTicketDto);
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u5e7f\u544a\u5238\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25");
                e.printStackTrace();
            }
            rs.setReturnValue((Object)id);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u6dfb\u52a0\u5e7f\u544a\u5238\u51fa\u9519");
            return rs;
        }
        return rs;
    }

    @LogBefore(user="advertiser", operType="/updateTicket", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/updateTicket"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<Boolean> updateTicket(HttpServletRequest request, @RequestBody AdTicketDto adTicketDto) {
        ResultModel rs = new ResultModel();
        if (adTicketDto == null || adTicketDto.getId() == null) {
            return ResultModelFactory.FAIL500((String)"\u5e7f\u544a\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List adTickets = null;
        AdTicket adTicket = null;
        try {
            adTickets = this.adTicketService.findByIds(String.valueOf(adTicketDto.getId()));
            if (adTickets == null || adTickets.isEmpty()) {
                return ResultModelFactory.FAIL500((String)"\u5e7f\u544a\u5238\u4e0d\u5b58\u5728");
            }
            adTicket = (AdTicket)adTickets.get(0);
            if (adTicket.getStatus() != null && adTicket.getStatus() > 0 && (3 != adTicket.getStatus() || adTicket.getLastStatus() > 0)) {
                adTicketDto.setLastStatus(adTicket.getStatus().shortValue());
                if (2 == adTicket.getStatus()) {
                    adTicketDto.setPauseReason(adTicket.getPauseReason());
                }
            }
            if (adTicket.getStatus() != null && adTicket.getStatus() == -2) {
                adTicketDto.setStatus(Short.valueOf((short)-2));
            }
            if (this.adTicketService.checkTagNeedAudit(adTicketDto.getId()).booleanValue() && this.adTicketService.checkTicketAssets(adTicketDto, adTicket, null).booleanValue()) {
                adTicketDto.setStatus(Short.valueOf((short)-2));
                AdTicketUrlTest result = this.adTicketService.findTicketUrlTest(Long.valueOf(adTicketDto.getId().longValue()));
                if (null == result) {
                    AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
                    adTicketUrlTest.setTicketId(Long.valueOf(adTicketDto.getId().longValue()));
                    adTicketUrlTest.setActionType(Short.valueOf((short)1));
                    adTicketUrlTest.setDealStatus(Short.valueOf((short)0));
                    adTicketUrlTest.setCreateTime(new Date());
                    adTicketUrlTest.setModifyTime(new Date());
                    this.adTicketService.addTicketUrlTest(adTicketUrlTest);
                    LOGGER.info("------\u5e7f\u544a\u4e3b\u94fe\u63a5\u6d4b\u8bd5\u8868\u6570\u636e\u63d2\u5165----");
                } else {
                    result.setModifyTime(new Date());
                    result.setActionType(Short.valueOf((short)1));
                    result.setDealStatus(Short.valueOf((short)0));
                    this.adTicketService.updateTicketUrlTest(result);
                    LOGGER.info("------\u5e7f\u544a\u4e3b\u94fe\u63a5\u6d4b\u8bd5\u8868\u6570\u636e\u4fee\u6539----");
                }
            }
            AdTicketVo record = this.adTicketService.findById(Long.valueOf(adTicketDto.getId().longValue()));
            AdTicketDto adTicketDtoParam = new AdTicketDto();
            if (record != null) {
                List flowPageIdByTicket;
                AdTicketVo updateParam = AdvertiserTicketNewController.updateParam(record, adTicketDto);
                if (CollectionUtils.isNotEmpty((Collection)record.getAdFlows())) {
                    ArrayList adFlowPackageArrayList = new ArrayList();
                    for (Object param : record.getAdFlows()) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("id", param.getId());
                        hashMap.put("flowPackageId", param.getFlowPackageId());
                        hashMap.put("packageName", param.getPackageName());
                        hashMap.put("count", param.getCount());
                        hashMap.put("consume", param.getConsume());
                        if (param.getPrice() != null) {
                            Money money = Money.ofLi((long)param.getPrice());
                            hashMap.put("price", money.getYuan());
                        } else {
                            hashMap.put("price", 0);
                        }
                        hashMap.put("quota", param.getQuota());
                        hashMap.put("ticketId", param.getTicketId());
                        hashMap.put("type", param.getType());
                        adFlowPackageArrayList.add(hashMap);
                    }
                    adTicketDtoParam.setFlowPackageArray(JSON.toJSONString(adFlowPackageArrayList));
                }
                if (!CollectionUtils.isEmpty((Collection)(flowPageIdByTicket = this.adTicketFlowNewService.findFlowPageIdByTicket(Long.valueOf(record.getId().longValue()))))) {
                    ArrayList<Long> ids = new ArrayList<Long>();
                    for (AdFlowPackageNewVo param : flowPageIdByTicket) {
                        ids.add(param.getId());
                    }
                    adTicketDtoParam.setFlowPackageIdArray(JSON.toJSONString(ids));
                }
                if (CollectionUtils.isNotEmpty((Collection)record.getPositionTimesLimitConfig())) {
                    adTicketDtoParam.setPositionTimesLimitConfig(JSON.toJSONString((Object)record.getPositionTimesLimitConfig()));
                }
                BeanUtils.copyProperties((Object)updateParam, (Object)adTicketDtoParam);
                AdTicketDto.ControlDto controlDto = new AdTicketDto.ControlDto();
                AdTicketVo.ControlVo controlVo = updateParam.getControlVo();
                BeanUtils.copyProperties((Object)controlVo, (Object)controlDto);
                adTicketDtoParam.setControlDto(controlDto);
                AdTicketOcpcConf ocpcConf = this.adTicketOcpcService.selectByTicketId(adTicket.getId());
                if (ocpcConf != null) {
                    AdTicketDto.OcpcConfDto ocpcConfDto = new AdTicketDto.OcpcConfDto();
                    ocpcConfDto.setTicketId(ocpcConf.getTicketId());
                    ocpcConfDto.setIsSupportOcpc(ocpcConf.getIsSupportOcpc());
                    if (ocpcConf.getCpaExpectPrice() != null) {
                        ocpcConfDto.setCpaExpectPrice(Double.valueOf(Money.ofLi((long)ocpcConf.getCpaExpectPrice().intValue()).getYuan()));
                    }
                    if (ocpcConf.getCpaDeepExpectPrice() != null) {
                        ocpcConfDto.setCpaDeepExpectPrice(Double.valueOf(Money.ofLi((long)ocpcConf.getCpaDeepExpectPrice().intValue()).getYuan()));
                    }
                    ocpcConfDto.setCloseThreshold(ocpcConf.getCloseThreshold());
                    ocpcConfDto.setDeepExpectActionType(ocpcConf.getDeepExpectActionType());
                    adTicketDtoParam.setOcpcConf(ocpcConfDto);
                }
            }
            LOGGER.info("\u5e7f\u544a\u5238\u3010{}\u3011\u6700\u7ec8\u66f4\u65b0\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)adTicketDtoParam.getId(), (Object)JsonHelper.convert((Object)adTicketDtoParam));
            this.adTicketService.update(CommonConstant.Opera.Platform.ADVERTISER, adTicketDtoParam, adTicketDtoParam.getCreateUser());
            try {
                if (adTicketDto.getId() != null && adTicketDto.getAdvertiser() != null && RedisKeys.advertisers.contains(adTicketDto.getAdvertiser())) {
                    this.jedisUpdater.hupdate(RedisKeys.getPddTickets(), String.valueOf(adTicketDto.getId()), (Object)adTicketDto.getAdvertiser());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u62fc\u591a\u591a\u5238\u5165Redis\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
            rs.setReturnValue((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5e7f\u544a\u5238\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/getTicketById"}, method={RequestMethod.GET})
    public ResultModel<AdTicketVo> find(@RequestParam(required=true, name="id") Long id) {
        ResultModel rs = new ResultModel();
        AdTicketVo result = null;
        try {
            result = this.adTicketService.findById(id);
            rs.setReturnValue((Object)AdvertiserTicketNewController.queryResultParam(result));
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u5e7f\u544a\u5238\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/checkTicketExistAssets"}, method={RequestMethod.GET})
    public ResultModel<Boolean> checkTicketExistAssets(@RequestParam(name="id") Long id) {
        ResultModel rs = new ResultModel();
        Boolean result = null;
        try {
            result = this.adTicketAssetsService.checkTicketExistAssets(id);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u51fa\u9519");
        }
        return rs;
    }

    public static AdTicketVo queryResultParam(AdTicketVo result) {
        AdTicketVo record = null;
        AdTicketVo.ControlVo controlVo = null;
        if (result != null) {
            record = new AdTicketVo();
            controlVo = new AdTicketVo.ControlVo();
            record.setStatus(result.getStatus());
            record.setId(result.getId());
            record.setAssetsids(result.getAssetsids());
            record.setAdvertiserName(result.getAdvertiserName());
            record.setAdvertiser(result.getAdvertiser());
            record.setName(result.getName());
            record.setSettleType(result.getSettleType());
            record.setPrice(result.getPrice());
            record.setType(result.getType());
            record.setAssetscouponsids(result.getAssetscouponsids());
            record.setCouponsInfoVo(result.getCouponsInfoVo());
            record.setAssetsadxids(result.getAssetsadxids());
            record.setAdxConfVo(result.getAdxConfVo());
            record.setAssetsinspirevideoids(result.getAssetsinspirevideoids());
            record.setInspireVideoConfVo(result.getInspireVideoConfVo());
            if (result.getBudgetDaily() == 999999.0) {
                record.setBudgetDaily(null);
            } else {
                record.setBudgetDaily(result.getBudgetDaily());
            }
            record.setUrl(result.getUrl());
            record.setCitys(result.getCitys());
            if (StringUtil.isNotBlank((CharSequence)result.getCitys())) {
                record.setBooleanCitys(Boolean.valueOf(true));
            }
            record.setOss(result.getOss());
            record.setIsSupportWechat(result.getIsSupportWechat());
            record.setValidStartDate(result.getValidStartDate());
            record.setValidEndDate(result.getValidEndDate());
            if (result.getControlVo() != null) {
                controlVo.setTimes(result.getControlVo().getTimes());
                if (StringUtil.isNotBlank((CharSequence)result.getControlVo().getTimes())) {
                    controlVo.setBooleanTimes(Boolean.valueOf(true));
                }
            }
            record.setApps(result.getApps());
        }
        record.setControlVo(controlVo);
        return record;
    }

    public static AdTicketVo updateParam(AdTicketVo record, AdTicketDto adTicketDto) {
        record.setApps(adTicketDto.getApps());
        record.setLog(adTicketDto.getLog());
        record.setId(adTicketDto.getId());
        record.setAssetsids(null);
        record.setPrice(adTicketDto.getPrice());
        record.setAdvertiser(adTicketDto.getAdvertiser());
        record.setCreateUser(adTicketDto.getCreateUser());
        record.setModifyUser(adTicketDto.getCreateUser());
        if (adTicketDto.getStatus() != null && adTicketDto.getStatus() == -2) {
            record.setStatus(Short.valueOf((short)-2));
        }
        record.setName(adTicketDto.getName());
        if (adTicketDto.getBudgetDaily() == null) {
            record.setBudgetDaily(Double.valueOf(999999.0));
        } else {
            record.setBudgetDaily(adTicketDto.getBudgetDaily());
        }
        record.setUrl(adTicketDto.getUrl());
        record.setBooleanCitys(adTicketDto.getBooleanCitys());
        record.setCitys(adTicketDto.getCitys());
        record.setOss(adTicketDto.getOss());
        record.setIsSupportWechat(adTicketDto.getIsSupportWechat());
        record.setValidStartDate(adTicketDto.getValidStartDate());
        record.setValidEndDate(adTicketDto.getValidEndDate());
        record.setWeight(Double.valueOf(100.0));
        record.setApps(adTicketDto.getApps());
        if (adTicketDto.getControlDto() != null) {
            record.getControlVo().setBooleanTimes(adTicketDto.getControlDto().getBooleanTimes());
            record.getControlVo().setTimes(adTicketDto.getControlDto().getTimes());
        }
        if (record.getControlVo() != null) {
            String personsGrade = record.getControlVo().getPersonsGrade();
            LOGGER.info("personsGrade\u7684json\u4e32\u4e3a\uff1a" + personsGrade);
            if (StringUtil.isNotEmpty((CharSequence)personsGrade)) {
                if ("[]".equals(personsGrade)) {
                    record.getControlVo().setPersonsGrade(null);
                } else {
                    List confs = JSON.parseArray((String)personsGrade, AdTicketGetuiTagRef.class);
                    if (CollectionUtils.isEmpty((Collection)confs)) {
                        record.getControlVo().setPersonsGrade(null);
                    } else {
                        StringBuffer buffer = new StringBuffer();
                        for (AdTicketGetuiTagRef conf : confs) {
                            buffer.append(conf.getTagGroupCode()).append("-").append(conf.getTagGroupValue().replace(",", "-")).append(",");
                        }
                        if (buffer.length() > 0) {
                            buffer.deleteCharAt(buffer.length() - 1);
                        }
                        LOGGER.info("personsGrade\u6700\u7ec8\u683c\u5f0f\u4e3a\uff1a" + buffer.toString());
                        record.getControlVo().setPersonsGrade(buffer.toString());
                    }
                }
            }
        }
        return record;
    }
}

