/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsTemplateContentMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.PanguCreativeMapperExt;
import com.bxm.adsmanager.facade.model.adx.AdxSyncFileDTO;
import com.bxm.adsmanager.facade.service.AdxCreativeSyncFacadeService;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContentExample;
import com.bxm.adsmanager.model.dao.adkeeper.PanguCreativeExample;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.PanguCreativeDTO;
import com.bxm.adsmanager.service.adkeeper.PanguCreativeService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdxCreativeSyncFacadeServiceImpl
implements AdxCreativeSyncFacadeService {
    @Autowired
    private PanguCreativeService panguCreativeService;
    @Autowired
    private PanguCreativeMapperExt panguCreativeMapperExt;
    @Autowired
    private AdAssetsTemplateContentMapper adAssetsTemplateContentMapper;

    public void upload(List<AdxSyncFileDTO> files) {
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        for (AdxSyncFileDTO dto : files) {
            if (dto == null) continue;
            this.upload(dto);
        }
    }

    public void upload(AdxSyncFileDTO file) {
        if (StringUtils.isEmpty((CharSequence)file.getUrl()) || StringUtils.isEmpty((CharSequence)file.getSize()) || StringUtils.isEmpty((CharSequence)file.getFormat())) {
            throw new RuntimeException("\u53c2\u6570\u7f3a\u5931");
        }
        String md5 = file.getMd5();
        PanguCreativeExample panguCreativeExample = new PanguCreativeExample();
        panguCreativeExample.createCriteria().andMd5EqualTo(md5);
        List creatives = this.panguCreativeMapperExt.selectByExample(panguCreativeExample);
        if (CollectionUtils.isNotEmpty((Collection)creatives)) {
            return;
        }
        String[] split = file.getSize().split("\\*");
        AdAssetsTemplateContentExample adAssetsTemplateContentExample = new AdAssetsTemplateContentExample();
        adAssetsTemplateContentExample.createCriteria().andPictureConstraintsLike(split[0] + "-" + split[1] + "%");
        int assetsTemplateContentCount = this.adAssetsTemplateContentMapper.countByExample(adAssetsTemplateContentExample);
        if (assetsTemplateContentCount == 0) {
            return;
        }
        PanguCreativeDTO dto = new PanguCreativeDTO();
        PanguCreativeDTO.Creative creative = new PanguCreativeDTO.Creative();
        creative.setFormat(file.getFormat());
        creative.setPicture(file.getUrl());
        creative.setMd5(md5);
        creative.setSize(file.getSize());
        dto.setCreatives((List)Lists.newArrayList((Object[])new PanguCreativeDTO.Creative[]{creative}));
        User user = new User();
        user.setUsername("facade adx sync creative");
        this.panguCreativeService.add(user, dto);
    }
}

