/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.adsprod.service.ProdAdvertiserIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCostLog;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsCode;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketThirdPartyCrowdPackageDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.adkeeper.AdTicketCostService;
import com.bxm.adsmanager.service.adkeeper.AdTicketCouponsCodeService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adkeeper.AdTicketThirdPartyCrowdPackageService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.TicketProfitForCpa;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adsmanager"})
public class FacadeTicketController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FacadeTicketController.class);
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdTicketCostService adTicketCostService;
    @Autowired
    private AdTicketCouponsCodeService adTicketCouponsCodeService;
    @Autowired
    private AdTicketThirdPartyCrowdPackageService adTicketThirdPartyCrowdPackageService;
    @Autowired
    private ProdAdvertiserIntegration prodAdvertiserIntegration;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;

    @LogBefore(user="adsprod", operType="/adsmanager/updateAdTicket", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/updateAdTicket"}, method={RequestMethod.POST})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") Long id, @RequestParam(required=true, name="reason") Integer reason, @RequestParam(required=true, name="status") Short status) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            AdTicket adTicket = new AdTicket();
            adTicket.setId(id);
            adTicket.setStatus(status);
            adTicket.setPauseReason(reason);
            adTicket.setModifyUser("\u524d\u7aef\u7cfb\u7edf\u5224\u65ad");
            LOGGER.info("adsprod\u8bf7\u6c42\u66f4\u65b0\u5e7f\u544a\u5238\u72b6\u6001:id=" + id + ",status=" + status + ",reason=" + reason);
            Integer result = this.adTicketService.facadeUpdateStatus(adTicket);
            User user = this.getUser(request, response);
            user.setUsername("adsprod\u524d\u7aef\u51fa\u5238\u7cfb\u7edf");
            user.setRoleCodes((List)Lists.newArrayList((Object[])new String[]{"adsprod\u524d\u7aef\u51fa\u5238\u7cfb\u7edf"}));
            this.addLogs(user, JSON.toJSONString((Object)(AdTicket.AdTicketStatus.getName((short)status) + "\u5e7f\u544a\u5238\uff0c\u539f\u56e0:" + AdTicket.AdTicketPAUSE.getName((int)reason))), id + "");
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("adsprod\u66f4\u65b0\u5e7f\u544a\u5238\u72b6\u6001\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return rs;
    }

    @RequestMapping(value={"/plusAdvertiserBalance"})
    public ResultModel<Long> plusAdvertiserBalance(@RequestParam(value="id") Long id, @RequestParam(value="value") Long value) {
        try {
            Long balance = this.prodAdvertiserIntegration.incrementBalance(BigInteger.valueOf(id), value);
            return ResultModelFactory.SUCCESS((Serializable)balance);
        }
        catch (Exception e) {
            LOGGER.error("pushAdvertiserBalance:", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/pushCpaProfitData"}, method={RequestMethod.POST})
    public ResultModel<?> pushCpaProfitData(@RequestBody List<TicketProfitForCpa> data) {
        try {
            String rst = this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.TICKET_PROFIT_FOR_CPA.getServiceName(), (Map)Maps.newHashMap(), JsonHelper.convert2bytes(data));
            if (StringUtils.isBlank((String)rst)) {
                return ResultModelFactory.FAIL500((String)"Push failed!");
            }
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"Push failed!");
        }
    }

    @RequestMapping(value={"/pushPosition/{id}"}, method={RequestMethod.POST})
    public ResultModel<?> pushPosition(@PathVariable(value="id") String positionId, @RequestBody Position position) {
        try {
            HashMap parameter = Maps.newHashMap();
            parameter.put(ProdServiceNameEnum.POSITION.getParameters(), positionId);
            String rst = this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION.getServiceName(), (Map)parameter, JsonHelper.convert2bytes((Object)position));
            if (StringUtils.isBlank((String)rst)) {
                return ResultModelFactory.FAIL500((String)"Push failed!");
            }
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"Push failed!");
        }
    }

    @RequestMapping(value={"/addTicketCostLog"}, method={RequestMethod.POST})
    public ResultModel addTicketCostLog(@RequestBody AdTicketCostLog adTicketCostLog) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setSuccessed(this.adTicketCostService.insert(adTicketCostLog).booleanValue());
        }
        catch (Exception e) {
            LOGGER.error("\u5238\u63d0\u9192\u8bb0\u5f55\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5238\u63d0\u9192\u8bb0\u5f55\u6dfb\u52a0\u5931\u8d25");
        }
        return resultModel;
    }

    @LogBefore(user="adsprod", operType="/adsmanager/updateTicketCouponsCode", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/updateTicketCouponsCode"}, method={RequestMethod.POST})
    public ResultModel updateTicketCouponsCode(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="ticketId") Long ticketId, @RequestParam(required=true, name="status") Short status, @RequestParam(required=false, name="firstShowTime") Long firstShowTime, @RequestParam(required=false, name="useTime") Long useTime, @RequestParam(required=true, name="usePositionId") String usePositionId, @RequestParam(required=true, name="bindDeviceNo") String bindDeviceNo, @RequestParam(required=true, name="couponsCode") String couponsCode) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            AdTicketCouponsCode adTicketCouponsCode = new AdTicketCouponsCode();
            adTicketCouponsCode.setTicketId(ticketId);
            adTicketCouponsCode.setStatus(status);
            if (firstShowTime != null) {
                adTicketCouponsCode.setFirstShowTime(new Date(firstShowTime));
            }
            if (useTime != null) {
                adTicketCouponsCode.setUseTime(new Date(useTime));
            }
            adTicketCouponsCode.setUsePositionId(usePositionId);
            adTicketCouponsCode.setBindDeviceNo(bindDeviceNo);
            adTicketCouponsCode.setCouponsCode(couponsCode);
            adTicketCouponsCode.setCreateUser("\u524d\u7aef\u7cfb\u7edf\u5224\u65ad");
            adTicketCouponsCode.setModifyUser("\u524d\u7aef\u7cfb\u7edf\u5224\u65ad");
            adTicketCouponsCode.setModifyTime(new Date());
            Integer result = this.adTicketCouponsCodeService.facadeUpdateTicketCouponsCode(adTicketCouponsCode);
            User user = this.getUser(request, response);
            user.setUsername("adsprod\u524d\u7aef\u51fa\u5238\u7cfb\u7edf");
            user.setRoleCodes((List)Lists.newArrayList((Object[])new String[]{"adsprod\u524d\u7aef\u51fa\u5238\u7cfb\u7edf"}));
            this.addLogs(user, JSON.toJSONString((Object)(couponsCode + "\u5238\u7801\u4fe1\u606f\u66f4\u65b0")), ticketId + "");
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("adsprod\u66f4\u65b0\u5e7f\u544a\u5238\u4f18\u60e0\u5238\u7801\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return rs;
    }

    @LogBefore(user="adsprod", operType="/adsmanager/adTicketThirdPartyCrowdPackage/getList", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/adTicketThirdPartyCrowdPackage/getList"}, method={RequestMethod.POST})
    public ResultModel getThirdPartyCrowdPackageList(@RequestParam(required=false, name="projectType") Short projectType, @RequestParam(required=false, name="packageSource") Short packageSource) {
        ResultModel rs = new ResultModel();
        try {
            AdTicketThirdPartyCrowdPackageDto adTicketThirdPartyCrowdPackageDto = new AdTicketThirdPartyCrowdPackageDto();
            adTicketThirdPartyCrowdPackageDto.setProjectType(projectType);
            adTicketThirdPartyCrowdPackageDto.setPackageSource(packageSource);
            rs.setReturnValue((Object)this.adTicketThirdPartyCrowdPackageService.getList(adTicketThirdPartyCrowdPackageDto));
        }
        catch (Exception e) {
            LOGGER.error("adsprod\u83b7\u53d6\u4eba\u7fa4\u5305\u914d\u7f6e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return rs;
    }
}

