/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.logs;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.logs.LogsIntegration;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.log.facade.dao.Page;
import com.bxm.log.facade.dto.LogModelDto;
import com.bxm.util.dto.ResultModel;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logs"})
public class LogsController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(LogsController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(LogsController.class);
    @Autowired
    private LogsIntegration logsIntegration;

    @RequestMapping(value={"/find"})
    public ResultModel<Page<LogModel>> dealAppCash(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="adticketId", required=false) String adticketId, @RequestParam(name="startTime", required=true) Long startTime, @RequestParam(name="endTime", required=true) Long endTime, @RequestParam(name="pageNum", required=false) Integer pageNum, @RequestParam(name="pageSize", required=false) Integer pageSize, @RequestParam(name="logInfo", required=false) String logInfo) {
        ResultModel resultModel = new ResultModel();
        try {
            LogModelDto dto = new LogModelDto();
            dto.setPageNum(pageNum);
            dto.setPageSize(pageSize);
            dto.setStartDateTime(startTime);
            dto.setEndDateTime(endTime);
            dto.setAdticketId(adticketId);
            dto.setLogInfo(logInfo);
            dto.setCollectionName("logs_adsmanager");
            resultModel.setReturnValue((Object)this.logsIntegration.find(dto));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorCode(e.getMessage());
        }
        return resultModel;
    }

    @PostMapping(value={"/addLogs"})
    public void add(@RequestBody @Validated AddLogDto addLogDto) {
        log.info("\u5916\u90e8\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)addLogDto));
        try {
            String ticketId = addLogDto.getTicketId();
            if (StringUtils.isNotBlank((CharSequence)ticketId)) {
                String[] ticketIds;
                for (String id : ticketIds = ticketId.split(",")) {
                    String userAccount = "-";
                    LogModel logModel = new LogModel.Builder().userName(userAccount).userAccount("\u7cfb\u7edf").parentAccount(userAccount).content(addLogDto.getContent()).adticketId(id).ip("-").build();
                    this.logsIntegration.add(logModel);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    static class AddLogDto
    implements Serializable {
        private String content;
        private String ticketId;

        public String getContent() {
            return this.content;
        }

        public String getTicketId() {
            return this.ticketId;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddLogDto)) {
                return false;
            }
            AddLogDto other = (AddLogDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$ticketId = this.getTicketId();
            String other$ticketId = other.getTicketId();
            return !(this$ticketId == null ? other$ticketId != null : !this$ticketId.equals(other$ticketId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AddLogDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $ticketId = this.getTicketId();
            result = result * 59 + ($ticketId == null ? 43 : $ticketId.hashCode());
            return result;
        }

        public String toString() {
            return "LogsController.AddLogDto(content=" + this.getContent() + ", ticketId=" + this.getTicketId() + ")";
        }
    }
}

