/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.integration.adsmedia.media.MediaCommonConfigFacadeIntegration;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeDto;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeRo;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/media"})
public class MediaCommonConfigController {
    @Autowired
    private MediaCommonConfigFacadeIntegration mediaCommonConfigFacadeIntegration;

    @RequestMapping(value={"/mediaConfigList"}, method={RequestMethod.GET})
    public ResultModel<List<PositionClassTypeRo>> queryPositionClassTypeList(@RequestParam(value="parentId", required=false, defaultValue="0") Long parentId, @RequestParam(value="typeCode") String typeCode, @RequestParam(value="name", required=false) String name) {
        PositionClassTypeDto param = new PositionClassTypeDto();
        param.setParentId(parentId);
        param.setTypeCode(typeCode);
        param.setName(name);
        return this.mediaCommonConfigFacadeIntegration.queryPositionClassTypeList(param);
    }

    @RequestMapping(value={"/mediaConfigPageList"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<PositionClassTypeRo>> queryPositionClassTypePageList(@RequestParam(value="parentId", required=false, defaultValue="0") Long parentId, @RequestParam(value="typeCode") String typeCode, @RequestParam(value="name", required=false) String name, @RequestParam(value="pageNum", required=true) Integer pageNum, @RequestParam(value="pageSize", required=true) Integer pageSize) {
        PositionClassTypeDto param = new PositionClassTypeDto();
        param.setParentId(parentId);
        param.setTypeCode(typeCode);
        param.setName(name);
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);
        return this.mediaCommonConfigFacadeIntegration.queryPositionClassTypePageList(param);
    }

    @RequestMapping(value={"/getById"}, method={RequestMethod.GET})
    public ResultModel<PositionClassTypeRo> getPositionClassTypeById(@RequestParam(value="id") Long id) {
        return this.mediaCommonConfigFacadeIntegration.getPositionClassTypeById(id);
    }

    @LogBefore(operType="/media/config", keyName="\u66f4\u65b0\u5a92\u4f53\u914d\u7f6e\u4fe1\u606f")
    @RequestMapping(value={"/config"}, method={RequestMethod.PUT})
    public ResultModel<Boolean> updatePositionClassTypeById(HttpServletRequest request, PositionClassTypeRo positionClassType) {
        ResultModel resultModel = new ResultModel();
        if (null == positionClassType || positionClassType != null && positionClassType.getId() == null) {
            resultModel.setSuccessed(false);
            resultModel.setReturnValue((Object)false);
            resultModel.setErrorDesc("ID\u4e0d\u80fd\u4e3a\u7a7a");
            return resultModel;
        }
        return this.mediaCommonConfigFacadeIntegration.updatePositionClassTypeById(positionClassType);
    }

    @LogBefore(operType="/media/config", keyName="\u65b0\u589e\u5a92\u4f53\u914d\u7f6e\u4fe1\u606f")
    @RequestMapping(value={"/config"}, method={RequestMethod.POST})
    public ResultModel<Boolean> addPositionClassType(HttpServletRequest request, PositionClassTypeRo positionClassType) {
        ResultModel resultModel = new ResultModel();
        if (null == positionClassType || positionClassType != null && positionClassType.getParentId() == null) {
            resultModel.setSuccessed(false);
            resultModel.setReturnValue((Object)false);
            resultModel.setErrorDesc("parentId\u4e0d\u80fd\u4e3a\u7a7a");
            return resultModel;
        }
        if (StringUtils.isBlank((CharSequence)positionClassType.getTypeCode())) {
            resultModel.setSuccessed(false);
            resultModel.setReturnValue((Object)false);
            resultModel.setErrorDesc("typeCode\u4e0d\u80fd\u4e3a\u7a7a");
            return resultModel;
        }
        return this.mediaCommonConfigFacadeIntegration.addPositionClassType(positionClassType);
    }

    @LogBefore(operType="/media/delById", keyName="\u5220\u9664\u5a92\u4f53\u914d\u7f6e\u4fe1\u606f")
    @RequestMapping(value={"/delById"}, method={RequestMethod.DELETE})
    public ResultModel<Boolean> delPositionClassTypeById(@RequestParam(value="id") Long id, @RequestParam(value="typeCode") String typeCode) {
        return this.mediaCommonConfigFacadeIntegration.delPositionClassTypeById(id, typeCode);
    }
}

