/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionBlackAppIdDto;
import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionBlackAppIdSearchDto;
import com.bxm.adsmanager.service.media.MediaPositionBlackAppIdService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mediaPositionBlackAppId"})
public class MediaPositionBlackAppIdController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MediaPositionBlackAppIdController.class);
    @Autowired
    private MediaPositionBlackAppIdService mediaPositionBlackAppIdService;
    private static final ReentrantLock dataLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogBefore(operType="/mediaPositionBlackAppId/save", keyName="\u5e7f\u544a\u4f4dAppId\u9ed1\u540d\u5355\u6dfb\u52a0")
    @RequestMapping(value={"/save"})
    public ResultModel savePositionBlackAppId(@Validated(value={MediaPositionBlackAppIdDto.Add.class}) MediaPositionBlackAppIdDto dto) throws Exception {
        boolean tryLock = dataLock.tryLock(5L, TimeUnit.SECONDS);
        try {
            if (!tryLock) {
                ResultModel resultModel = ResultModelFactory.FAIL500((String)"\u8bf7\u6c42\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                return resultModel;
            }
            List list = this.mediaPositionBlackAppIdService.savePositionBlackAppId(dto);
            ResultModel resultModel = ResultModelFactory.SUCCESS((Serializable)((Object)StringUtils.join((Collection)list, (String)",")));
            return resultModel;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ResultModel resultModel = ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u5f02\u5e38");
            return resultModel;
        }
        finally {
            if (tryLock) {
                dataLock.unlock();
            }
        }
    }

    @RequestMapping(value={"/update"})
    @LogBefore(operType="/mediaPositionBlackAppId/update", keyName="\u5e7f\u544a\u4f4dAppId\u9ed1\u540d\u5355\u66f4\u65b0")
    public ResultModel updatePositionBlackAppId(@Validated(value={MediaPositionBlackAppIdDto.Update.class}) MediaPositionBlackAppIdDto dto) {
        this.mediaPositionBlackAppIdService.updatePositionBlackAppId(dto);
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/list"})
    public ResultModel list(MediaPositionBlackAppIdSearchDto dto) {
        return ResultModelFactory.SUCCESS((Serializable)this.mediaPositionBlackAppIdService.list(dto));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/delete"})
    @LogBefore(operType="/mediaPositionBlackAppId/delete", keyName="\u5e7f\u544a\u4f4dAppId\u9ed1\u540d\u5355\u5220\u9664")
    public ResultModel delete(@RequestParam(value="ids") String ids) throws Exception {
        if (StringUtils.isBlank((String)ids)) {
            return ResultModelFactory.FAIL400((String)"\u7f3a\u5c11\u53c2\u6570\uff1aids");
        }
        boolean tryLock = dataLock.tryLock(5L, TimeUnit.SECONDS);
        try {
            if (!tryLock) {
                ResultModel resultModel = ResultModelFactory.FAIL500((String)"\u8bf7\u6c42\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                return resultModel;
            }
            this.mediaPositionBlackAppIdService.delete(ids);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ResultModel resultModel = ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u5f02\u5e38");
            return resultModel;
        }
        finally {
            if (tryLock) {
                dataLock.unlock();
            }
        }
        return ResultModelFactory.SUCCESS();
    }
}

