/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionWhiteTicketDto;
import com.bxm.adsmanager.service.media.MediaPositionWhiteTicketService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mediaPositionWhiteTicket"})
public class MediaPositionWhiteTicketController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionWhiteTicketController.class);
    @Autowired
    private MediaPositionWhiteTicketService mediaPositionWhiteTicketService;

    @LogBefore(operType="/mediaPositionWhiteTicket/batchSaveorUpdate", keyName="\u5e7f\u544a\u4f4d\u767d\u540d\u5355\u5e7f\u544a\u5238\u6dfb\u52a0")
    @RequestMapping(value={"/batchSaveorUpdate"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel batchAdd(HttpServletRequest request, HttpServletResponse response, MediaPositionWhiteTicketDto mediaPositionWhiteTicketDto) throws Exception {
        try {
            if (BeanValidator.validateGroup((Object)mediaPositionWhiteTicketDto, (Class[])new Class[]{MediaPositionWhiteTicketDto.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)mediaPositionWhiteTicketDto, (Class[])new Class[]{MediaPositionWhiteTicketDto.Add.class}).getMessage());
            }
            String userName = this.getUser(request, response).getUsername();
            this.mediaPositionWhiteTicketService.batchSaveorUpdate(mediaPositionWhiteTicketDto, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (PushProdException p) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u4f4d\u767d\u540d\u5355\u5e7f\u544a\u5238\u51fa\u9519" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u4f4d\u767d\u540d\u5355\u5e7f\u544a\u5238\u51fa\u9519");
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u4f4d\u767d\u540d\u5355\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @LogBefore(operType="/mediaPositionWhiteTicket/savePositionWhiteTicket", keyName="\u5e7f\u544a\u4f4d\u767d\u540d\u5355\u5e7f\u544a\u5238\u6dfb\u52a0")
    @RequestMapping(value={"/savePositionWhiteTicket"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel savePositionWhiteTicket(HttpServletRequest request, HttpServletResponse response, MediaPositionWhiteTicketDto mediaPositionWhiteTicketDto) throws Exception {
        ResultModel rs = new ResultModel();
        try {
            if (StringUtils.isBlank((String)mediaPositionWhiteTicketDto.getTicketId())) {
                return ResultModelFactory.FAIL400((String)"\u8bf7\u8f93\u5165\u767d\u540d\u5355\u5238");
            }
            String userName = this.getUser(request, response).getUsername();
            List ticketList = this.mediaPositionWhiteTicketService.savePositionWhiteTicket(mediaPositionWhiteTicketDto, userName);
            if (CollectionUtils.isNotEmpty((Collection)ticketList)) {
                Collections.sort(ticketList);
                rs.setReturnValue((Object)ticketList);
                rs.setErrorDesc("\u5b58\u5728\u65e0\u6548\u7684\u767d\u540d\u5355\u5238");
                return rs;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u4f4d\u767d\u540d\u5355\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }
}

