/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.model.dto.mediamanager.MediaTestDto;
import com.bxm.adsmanager.model.vo.media.AdMediaTestVo;
import com.bxm.adsmanager.model.vo.media.MediaTicketVo;
import com.bxm.adsmanager.service.media.MediaTestService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mediaTest"})
public class MediaTestController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTestController.class);
    @Autowired
    private MediaTestService mediaTestService;

    @LogBefore(operType="/mediaTest/add", keyName="\u5a92\u4f53\u6d4b\u8bd5\u6dfb\u52a0")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, MediaTestDto mediaTestDto) {
        try {
            if (BeanValidator.validateGroup((Object)mediaTestDto, (Class[])new Class[]{MediaTestDto.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)mediaTestDto, (Class[])new Class[]{MediaTestDto.Add.class}).getMessage());
            }
            String userName = this.getUser(request, response).getUsername();
            this.mediaTestService.add(mediaTestDto, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5a92\u4f53\u6d4b\u8bd5\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<PageInfo<AdMediaTestVo>> findAll(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="appKey", required=false) String appKey, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="mjCode", required=false) String mjCode) {
        try {
            ResultModel rs = new ResultModel();
            PageInfo result = this.mediaTestService.findAllByAppKyeOrKeywords(appKey, keywords, mjCode, pageNum, pageSize);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5a92\u4f53\u6d4b\u8bd5\u5e7f\u544a\u4f4d\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u5a92\u4f53\u6d4b\u8bd5\u5e7f\u544a\u4f4d\u5217\u8868\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findAdMediaTestById"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<AdMediaTestVo> findAdMediaTestVoById(HttpServletRequest request, HttpServletResponse response, Long id) {
        ResultModel rs = new ResultModel();
        try {
            if (id == null) {
                return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AdMediaTestVo result = this.mediaTestService.findAdMediaTestVoById(id);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u5a92\u4f53\u6d4b\u8bd5\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/findTicketByParam"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<PageInfo<MediaTicketVo>> findTicketByParam(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="ids", required=false) String ids) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.mediaTestService.findTicketByParam(keywords, pageNum, pageSize, ids);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5a92\u4f53\u6d4b\u8bd5\u67e5\u627e\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/findTicketByParamAndIds"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<PageInfo<MediaTicketVo>> findTicketByParamAndIds(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="ids", required=false) String ids) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.mediaTestService.findTicketByParamAndIds(keywords, pageNum, pageSize, ids);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5a92\u4f53\u6d4b\u8bd5\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    @LogBefore(operType="/mediaTest/update", keyName="\u5a92\u4f53\u6d4b\u8bd5\u6dfb\u52a0")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, MediaTestDto mediaTestDto) {
        try {
            if (BeanValidator.validateGroup((Object)mediaTestDto, (Class[])new Class[]{MediaTestDto.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)mediaTestDto, (Class[])new Class[]{MediaTestDto.Add.class}).getMessage());
            }
            String userName = this.getUser(request, response).getUsername();
            this.mediaTestService.update(mediaTestDto, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5a92\u4f53\u6d4b\u8bd5\u5e7f\u544a\u4f4d\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @LogBefore(operType="/mediaTest/updateStatus", keyName="\u5a92\u4f53\u6d4b\u8bd5\u6dfb\u52a0")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel updateStatus(HttpServletRequest request, HttpServletResponse response, Long id, Integer type) {
        try {
            this.mediaTestService.updateStatus(id, type);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (Exception e) {
            LOGGER.error("\u5a92\u4f53\u6d4b\u8bd5\u4fee\u6539\u72b6\u6001\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @LogBefore(operType="/mediaTest/delete", keyName="\u5a92\u4f53\u6d4b\u8bd5\u6dfb\u52a0")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, Long id) {
        try {
            this.mediaTestService.delete(id);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (Exception e) {
            LOGGER.error("\u5a92\u4f53\u6d4b\u8bd5\u5220\u9664\u5e7f\u544a\u4f4d\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/findOcpcTicketByParam"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<PageInfo<MediaTicketVo>> findOcpcTicketByParam(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="ids", required=false) String ids) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.mediaTestService.findOcpcTicketByParam(keywords, pageNum, pageSize, ids);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5a92\u4f53\u6d4b\u8bd5\u9ed8\u8ba4\u52a0\u8f7d\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/findOcpcTicketId"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<List<Integer>> findOcpcTicketId() {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.mediaTestService.findOcpcTicketId());
        }
        catch (Exception e) {
            LOGGER.error("\u5a92\u4f53\u6d4b\u8bd5\u83b7\u53d6\u5e7f\u544a\u4f4d\u7684\u6240\u6709\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }
}

