/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.menu;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketProfitSearchDto;
import com.bxm.adsmanager.model.dto.menu.AdMenuDto;
import com.bxm.adsmanager.model.vo.AdMenuVo;
import com.bxm.adsmanager.model.vo.MenuPermissionVo;
import com.bxm.adsmanager.service.menu.AdMenuRoleService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/adMenu"})
@RestController
public class AdMenuController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdMenuController.class);
    @Autowired
    private AdMenuRoleService adMenuRoleService;

    @RequestMapping(value={"/findMenuByRole"}, method={RequestMethod.GET})
    public ResultModel<MenuPermissionVo> findAll(HttpServletRequest request, HttpServletResponse response, AdTicketProfitSearchDto search) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            MenuPermissionVo menuPermissionVo = new MenuPermissionVo();
            User user = this.getUser(request, response);
            List menus = this.adMenuRoleService.findMenuByRole(user.getRoleCodes());
            menuPermissionVo.setUsername(user.getUsername());
            menuPermissionVo.setRole(user.getRoleCodes());
            menuPermissionVo.setPermission(this.menuVo2Dto(menus));
            rs.setReturnValue((Object)menuPermissionVo);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u89d2\u8272\u83dc\u5355\u5217\u8868\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u67e5\u8be2\u89d2\u8272\u83dc\u5355\u5217\u8868\u9519\u8bef");
        }
        return rs;
    }

    private List<AdMenuDto> menuVo2Dto(List<AdMenuVo> menus) {
        ArrayList<AdMenuDto> result = new ArrayList<AdMenuDto>();
        for (AdMenuVo vo : menus) {
            result.add(new AdMenuDto(vo));
        }
        return result;
    }
}

