/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.sys;

import com.bxm.adsmanager.service.sys.SysService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
public class SysController {
    private final SysService sysService;

    public SysController(SysService sysService) {
        this.sysService = sysService;
    }

    @GetMapping(value={"/list"})
    public ResultModel list() {
        SysVo vo = new SysVo();
        vo.setData(new TreeMap<String, String>(this.sysService.getAll()));
        return ResultModelFactory.SUCCESS((Serializable)vo);
    }

    @GetMapping(value={"/get"})
    public ResultModel get(@RequestParam(value="key") String key) {
        return ResultModelFactory.SUCCESS((Serializable)((Object)this.sysService.get(key)));
    }

    @PostMapping(value={"/update"})
    public ResultModel update(@RequestParam(value="key") String key, @RequestParam(value="value") String value) {
        this.sysService.put(key, value);
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping(value={"/delete"})
    public ResultModel delete(@RequestParam(value="key") String key) {
        this.sysService.delete(key);
        return ResultModelFactory.SUCCESS();
    }

    public static class SysVo
    implements Serializable {
        private Map<String, String> data;

        public Map<String, String> getData() {
            return this.data;
        }

        public void setData(Map<String, String> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SysVo)) {
                return false;
            }
            SysVo other = (SysVo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$data = this.getData();
            Map<String, String> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SysVo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "SysController.SysVo(data=" + this.getData() + ")";
        }
    }
}

