/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.third;

import com.bxm.adsmanager.model.ro.TxRo;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TicketAndTxController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketAndTxController.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    @RequestMapping(value={"/tx/saveOrUpdate"}, produces={"application/json"})
    public ResultModel<Boolean> saveOrUpdate(@RequestParam(value="ticketId") String ticketId, @RequestParam(value="txUserId") String txUserId, @RequestParam(value="type") String type) {
        ResultModel rs = new ResultModel();
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)type)) {
                this.updater.hupdateWithSelector(TicketAndTxController.txAndbxm(), txUserId, (Object)ticketId, 0);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)type)) {
                this.updater.hremoveWithSelector(TicketAndTxController.txAndbxm(), 0, new String[]{txUserId});
            }
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/tx/getList"}, produces={"application/json"})
    public ResultModel<List<TxRo>> getList() {
        ResultModel rs = new ResultModel();
        try {
            ArrayList<TxRo> list = new ArrayList<TxRo>();
            Map mapConfigAll = this.fetcher.hfetchallWithSelector(TicketAndTxController.txAndbxm(), String.class, 0);
            if (mapConfigAll != null) {
                for (String txUserId : mapConfigAll.keySet()) {
                    TxRo txRo = new TxRo();
                    txRo.setTxUserId(txUserId);
                    txRo.setTicketId((String)mapConfigAll.get(txUserId));
                    list.add(txRo);
                }
            }
            rs.setReturnValue(list);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    public static KeyGenerator txAndbxm() {
        return () -> KeyBuilder.build((Object[])new Object[]{"tengxun", "and", "bxm"});
    }
}

