/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.third;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.vo.weibo.WBToken;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WeiboController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(WeiboController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(WeiboController.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    private static final String tokenUrl = "https://api.biz.weibo.com/oauth/token";

    @RequestMapping(value={"/wb/code"}, produces={"application/json"})
    public ResultModel<Boolean> save(@RequestParam(value="code") String code, @RequestParam(value="state") String state) {
        ResultModel rs = new ResultModel();
        try {
            HashMap params = Maps.newHashMap();
            params.put("client_id", state);
            params.put("grant_type", "authorization_code");
            params.put("redirect_uri", "https%3A%2F%2Fmgr.bianxianmao.com%3A18501%2Fwb%2Fcode");
            params.put("code", code);
            String getTokenurl = OkHttpUtils.appendParams((String)tokenUrl, (Map)params);
            String value = OkHttpUtils.get((String)getTokenurl);
            WBToken token = (WBToken)JsonHelper.convert((String)value, WBToken.class);
            HashMap refreshParams = Maps.newHashMap();
            refreshParams.put("client_id", state);
            refreshParams.put("grant_type", "refresh_token");
            refreshParams.put("refresh_token", token.getRefresh_token());
            String refreshTokenurl = OkHttpUtils.appendParams((String)tokenUrl, (Map)refreshParams);
            String refreshValue = OkHttpUtils.get((String)refreshTokenurl);
            WBToken refreshToken = (WBToken)JsonHelper.convert((String)refreshValue, WBToken.class);
            Long exDate = System.currentTimeMillis() + Long.valueOf(token.getExpires_in()) * 1000L;
            Long refreshExDate = System.currentTimeMillis() + Long.valueOf(token.getRefresh_expires_in()) * 1000L;
            refreshToken.setExDate(DateUtil.dateTo14String((Date)new Date(exDate)));
            refreshToken.setRefresh_token(token.getRefresh_token());
            refreshToken.setRefresh_expires_in(token.getRefresh_expires_in());
            refreshToken.setRefreshExDate(DateUtil.dateTo14String((Date)new Date(refreshExDate)));
            this.updater.hupdate(CommonConstant.wbToken(), state, (Object)JsonHelper.convert((Object)refreshToken));
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    public static void main(String[] args) throws IOException {
        String value = "{\"access_token\":\"acb82da41ed33f172ae9ef22539c456f\",\"expires_in\":3600,\"refresh_token\":\"r25674b1112d75bb1441774863e0e2a3\",\"refresh_expires_in\":7776000,\"token_type\":\"Bearer\"}";
        WBToken token = (WBToken)JsonHelper.convert((String)value, WBToken.class);
        HashMap refreshParams = Maps.newHashMap();
        refreshParams.put("client_id", "202206273641659100");
        refreshParams.put("grant_type", "refresh_token");
        refreshParams.put("refresh_token", token.getRefresh_token());
        String refreshTokenurl = OkHttpUtils.appendParams((String)tokenUrl, (Map)refreshParams);
        for (int i = 0; i < 10; ++i) {
            String refreshValue = OkHttpUtils.get((String)refreshTokenurl);
            WBToken refreshToken = (WBToken)JsonHelper.convert((String)refreshValue, WBToken.class);
            System.out.println(JSON.toJSONString((Object)refreshToken));
        }
    }
}

