/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.third;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.ro.YDPostionidAndBxmRo;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class YDAndBXMController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(YDAndBXMController.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private AdTicketMapper adTicketMapper;

    @RequestMapping(value={"/ydAndBxm/save"}, produces={"application/json"})
    public ResultModel<Boolean> save(@RequestParam(value="ticketId") String ticketId, @RequestParam(value="assetsId") String assetsId, @RequestParam(value="ydPositionId") String ydPositionId) {
        ResultModel rs = new ResultModel();
        try {
            YDPostionidAndBxmRo ydPostionidAndBxmRo = new YDPostionidAndBxmRo();
            ydPostionidAndBxmRo.setAssetsId(assetsId);
            ydPostionidAndBxmRo.setYdPositionId(ydPositionId);
            ydPostionidAndBxmRo.setTicketId(ticketId);
            AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(ticketId)));
            ydPostionidAndBxmRo.setTicketType(adTicket.getType());
            Map mapConfigAll = this.fetcher.hfetchallWithSelector(YDAndBXMController.ydPositionIdAndBxmTickassetsIdetId(), YDPostionidAndBxmRo.class, 0);
            if (mapConfigAll != null) {
                for (YDPostionidAndBxmRo ydPostionidAndBxmRo1 : mapConfigAll.values()) {
                    if (!ydPostionidAndBxmRo1.getAssetsId().equalsIgnoreCase(assetsId) && !ydPostionidAndBxmRo1.getTicketId().equalsIgnoreCase(ticketId) && !ydPostionidAndBxmRo1.getYdPositionId().equalsIgnoreCase(ydPositionId)) continue;
                    rs.setSuccessed(false);
                    rs.setErrorDesc("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u5e7f\u544a\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165");
                    return rs;
                }
            }
            this.updater.hupdateWithSelector(YDAndBXMController.ydPositionIdAndBxmTickassetsIdetId(), ticketId, (Object)ydPostionidAndBxmRo, 0);
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @RequestMapping(value={"/ydAndBxm/update"}, produces={"application/json"})
    public ResultModel<Boolean> update(@RequestParam(value="ticketId") String ticketId, @RequestParam(value="assetsId") String assetsId, @RequestParam(value="ydPositionId") String ydPositionId, @RequestParam(value="oldTicketId") String oldTicketId) {
        ResultModel rs = new ResultModel();
        try {
            YDPostionidAndBxmRo ydPostionidAndBxmRo = new YDPostionidAndBxmRo();
            ydPostionidAndBxmRo.setAssetsId(assetsId);
            ydPostionidAndBxmRo.setYdPositionId(ydPositionId);
            ydPostionidAndBxmRo.setTicketId(ticketId);
            AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(ticketId)));
            ydPostionidAndBxmRo.setTicketType(adTicket.getType());
            Map mapConfigAll = this.fetcher.hfetchallWithSelector(YDAndBXMController.ydPositionIdAndBxmTickassetsIdetId(), YDPostionidAndBxmRo.class, 0);
            if (mapConfigAll != null) {
                for (YDPostionidAndBxmRo ydPostionidAndBxmRo1 : mapConfigAll.values()) {
                    if (ydPostionidAndBxmRo1.getTicketId().equalsIgnoreCase(oldTicketId) || !ydPostionidAndBxmRo1.getAssetsId().equalsIgnoreCase(assetsId) && !ydPostionidAndBxmRo1.getTicketId().equalsIgnoreCase(ticketId) && !ydPostionidAndBxmRo1.getYdPositionId().equalsIgnoreCase(ydPositionId)) continue;
                    rs.setSuccessed(false);
                    rs.setErrorDesc("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u5e7f\u544a\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165");
                    return rs;
                }
            }
            this.updater.hremoveWithSelector(YDAndBXMController.ydPositionIdAndBxmTickassetsIdetId(), 0, new String[]{oldTicketId});
            this.updater.hupdateWithSelector(YDAndBXMController.ydPositionIdAndBxmTickassetsIdetId(), ticketId, (Object)ydPostionidAndBxmRo, 0);
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @RequestMapping(value={"/ydAndBxm/delete"}, produces={"application/json"})
    public ResultModel<Boolean> delete(@RequestParam(value="ticketId") String ticketId) {
        ResultModel rs = new ResultModel();
        try {
            this.updater.hremoveWithSelector(YDAndBXMController.ydPositionIdAndBxmTickassetsIdetId(), 0, new String[]{ticketId});
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/ydAndBxm/getList"}, produces={"application/json"})
    public ResultModel<List<YDPostionidAndBxmRo>> getList(YdPositionQuery queryParam) {
        ResultModel rs = new ResultModel();
        try {
            ArrayList<YDPostionidAndBxmRo> list = new ArrayList<YDPostionidAndBxmRo>();
            Map mapConfigAll = this.fetcher.hfetchallWithSelector(YDAndBXMController.ydPositionIdAndBxmTickassetsIdetId(), YDPostionidAndBxmRo.class, 0);
            if (mapConfigAll != null) {
                for (YDPostionidAndBxmRo ro : mapConfigAll.values()) {
                    boolean allMatch = true;
                    if (StringUtils.isNotBlank((CharSequence)queryParam.getTicketId())) {
                        boolean bl = allMatch = allMatch && StringUtils.equals((CharSequence)queryParam.getTicketId(), (CharSequence)ro.getTicketId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)queryParam.getAssetsId())) {
                        boolean bl = allMatch = allMatch && StringUtils.equals((CharSequence)queryParam.getAssetsId(), (CharSequence)ro.getAssetsId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)queryParam.getYdPositionId())) {
                        allMatch = allMatch && StringUtils.equals((CharSequence)queryParam.getYdPositionId(), (CharSequence)ro.getYdPositionId());
                    }
                    AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(ro.getTicketId())));
                    ro.setTicketType(adTicket.getType());
                    if (null != queryParam.getTicketType()) {
                        boolean bl = allMatch = allMatch && queryParam.getTicketType().equals(ro.getTicketType());
                    }
                    if (!allMatch) continue;
                    list.add(ro);
                }
            }
            rs.setReturnValue(list);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    public static KeyGenerator ydPositionIdAndBxmTickassetsIdetId() {
        return () -> KeyBuilder.build((Object[])new Object[]{"YD", "AND", "BXM", "TICKETID"});
    }

    public class YdPositionQuery {
        private String ticketId;
        private String assetsId;
        private String ydPositionId;
        private Short ticketType;

        public String getTicketId() {
            return this.ticketId;
        }

        public String getAssetsId() {
            return this.assetsId;
        }

        public String getYdPositionId() {
            return this.ydPositionId;
        }

        public Short getTicketType() {
            return this.ticketType;
        }

        public void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public void setAssetsId(String assetsId) {
            this.assetsId = assetsId;
        }

        public void setYdPositionId(String ydPositionId) {
            this.ydPositionId = ydPositionId;
        }

        public void setTicketType(Short ticketType) {
            this.ticketType = ticketType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof YdPositionQuery)) {
                return false;
            }
            YdPositionQuery other = (YdPositionQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ticketId = this.getTicketId();
            String other$ticketId = other.getTicketId();
            if (this$ticketId == null ? other$ticketId != null : !this$ticketId.equals(other$ticketId)) {
                return false;
            }
            String this$assetsId = this.getAssetsId();
            String other$assetsId = other.getAssetsId();
            if (this$assetsId == null ? other$assetsId != null : !this$assetsId.equals(other$assetsId)) {
                return false;
            }
            String this$ydPositionId = this.getYdPositionId();
            String other$ydPositionId = other.getYdPositionId();
            if (this$ydPositionId == null ? other$ydPositionId != null : !this$ydPositionId.equals(other$ydPositionId)) {
                return false;
            }
            Short this$ticketType = this.getTicketType();
            Short other$ticketType = other.getTicketType();
            return !(this$ticketType == null ? other$ticketType != null : !((Object)this$ticketType).equals(other$ticketType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof YdPositionQuery;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ticketId = this.getTicketId();
            result = result * 59 + ($ticketId == null ? 43 : $ticketId.hashCode());
            String $assetsId = this.getAssetsId();
            result = result * 59 + ($assetsId == null ? 43 : $assetsId.hashCode());
            String $ydPositionId = this.getYdPositionId();
            result = result * 59 + ($ydPositionId == null ? 43 : $ydPositionId.hashCode());
            Short $ticketType = this.getTicketType();
            result = result * 59 + ($ticketType == null ? 43 : ((Object)$ticketType).hashCode());
            return result;
        }

        public String toString() {
            return "YDAndBXMController.YdPositionQuery(ticketId=" + this.getTicketId() + ", assetsId=" + this.getAssetsId() + ", ydPositionId=" + this.getYdPositionId() + ", ticketType=" + this.getTicketType() + ")";
        }
    }
}

