/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.weight;

import com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeightNew;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketPositionWeightNewDTO;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmanager.web.controller.common.MediaPositionController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/positionTicketWeight"})
@RestController
public class PositionTicketWeightController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionController.class);
    @Autowired
    private PositionTicketWeightService positionTicketWeightService;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo> findAll(AdTicketPositionWeightNewDTO search) {
        try {
            return ResultModelFactory.SUCCESS((Serializable)this.positionTicketWeightService.findAllNew(search));
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u544a\u4f4d\u5e7f\u544a\u5238\u5217\u8868\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @LogBefore(operType="/positionTicketWeight/updatePositionWeight", keyName="\u5e7f\u544a")
    @PostMapping(value={"/updatePositionWeight"})
    public ResultModel<?> updatePositionWeight(HttpServletRequest request, HttpServletResponse response, AdTicketPositionWeightNew model) {
        if (BeanValidator.validateGroup((Object)model, (Class[])new Class[]{AdTicketPositionWeightNew.Add.class}) != null) {
            return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)model, (Class[])new Class[]{AdTicketPositionWeightNew.Add.class}).getMessage());
        }
        try {
            User user = this.getUser(request, response);
            model.setCreateUser(user.getUsername());
            model.setUpdateUser(user.getUsername());
            this.positionTicketWeightService.updateOrInsert(model);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @LogBefore(operType="/positionTicketWeight/deletePositionWeight", keyName="\u5e7f\u544a")
    @PostMapping(value={"/deletePositionWeight"})
    public ResultModel<?> deletePositionWeight(HttpServletRequest request, HttpServletResponse response, AdTicketPositionWeightNew model) {
        if (BeanValidator.validateGroup((Object)model, (Class[])new Class[]{AdTicketPositionWeightNew.Delete.class}) != null) {
            return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)model, (Class[])new Class[]{AdTicketPositionWeightNew.Delete.class}).getMessage());
        }
        try {
            User user = this.getUser(request, response);
            model.setUpdateUser(user.getUsername());
            this.positionTicketWeightService.delete(model);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5e7f\u544a\u4f4d\u6743\u91cd\u503c\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }
}

