/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.interceptor;

import com.bxm.adsmanager.service.sys.SysService;
import com.bxm.adsmanager.web.controller.exception.VersionRequiredException;
import com.bxm.warcar.utils.StringHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class VersionInterceptor
implements HandlerInterceptor {
    private static final String VERSION = "version";
    private final SysService sysService;

    public VersionInterceptor(SysService sysService) {
        this.sysService = sysService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String need = this.sysService.get("adsmanager.required.version");
        if (StringUtils.isBlank((CharSequence)need)) {
            throw new RuntimeException("\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        String client = request.getHeader(VERSION);
        if (StringUtils.isBlank((CharSequence)client)) {
            client = request.getParameter(VERSION);
        }
        if (StringUtils.isBlank((CharSequence)client)) {
            return true;
        }
        if (!StringHelper.isNewVersion((String)need, (String)client)) {
            throw new VersionRequiredException(String.format("\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u7248\u672c\u53f7 %s \u4f4e\u4e8e %s\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002\u5982\u679c\u4ecd\u7136\u65e0\u6cd5\u89e3\u51b3\uff0c\u5efa\u8bae\u6e05\u7a7a\u6d4f\u89c8\u5668\u7f13\u5b58\u518d\u8bd5\u3002", client, need));
        }
        return true;
    }
}

