/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.adapter.bxm;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.api.adapter.RejectResponseModelAdapter;
import com.bxm.pangu.rta.api.adapter.bxm.BxmRequest;
import com.bxm.pangu.rta.api.adapter.bxm.BxmResponse;
import com.bxm.pangu.rta.api.constant.RtaMedia;
import com.bxm.pangu.rta.api.exception.ErrorCode;
import com.bxm.pangu.rta.api.model.QueryRequest;
import com.bxm.pangu.rta.api.model.QueryResponse;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.warcar.utils.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BxmModelAdapter
implements RejectResponseModelAdapter {
    private static final Logger log = LoggerFactory.getLogger(BxmModelAdapter.class);

    @Override
    public QueryRequest request(byte[] requestBody) {
        BxmRequest bxmRequest = (BxmRequest)JsonHelper.convert((byte[])requestBody, BxmRequest.class);
        log.info("BxmRequest:{}", (Object)JSONObject.toJSONString((Object)bxmRequest));
        String rtaId = this.findRtaId(bxmRequest);
        QueryRequest queryRequest = new QueryRequest();
        RtaRequest rtaRequest = new RtaRequest();
        rtaRequest.setOs(bxmRequest.getOs());
        rtaRequest.setImei(bxmRequest.getImei());
        rtaRequest.setImei_md5(bxmRequest.getImei_md5());
        rtaRequest.setOaid(bxmRequest.getOaid());
        rtaRequest.setOaid_md5(bxmRequest.getOaid_md5());
        rtaRequest.setAndroidid(bxmRequest.getAndroidid());
        rtaRequest.setAndroidid_md5(bxmRequest.getAndroidid_md5());
        rtaRequest.setIdfa(bxmRequest.getIdfa());
        rtaRequest.setIdfa_md5(bxmRequest.getIdfa_md5());
        queryRequest.setRtaRequest(rtaRequest);
        queryRequest.setRtaId(rtaId);
        return queryRequest;
    }

    @Override
    public byte[] response(QueryResponse response) {
        log.info("QueryResponse:{}", (Object)JSONObject.toJSONString((Object)response));
        BxmResponse bxmResponse = new BxmResponse();
        bxmResponse.setSc(response.getSc());
        bxmResponse.setBody(response.getBody());
        return JsonHelper.convert2bytes((Object)bxmResponse);
    }

    @Override
    public String getRtaMedia() {
        return RtaMedia.BXM.getId();
    }

    @Override
    public String findRtaId(Object requestObject) {
        if (requestObject instanceof BxmRequest) {
            return ((BxmRequest)requestObject).getRtaId();
        }
        return null;
    }

    @Override
    public byte[] reject(QueryRequest request, ErrorCode errorCode) {
        if (errorCode == null) {
            return new byte[0];
        }
        BxmResponse bxmResponse = new BxmResponse();
        bxmResponse.setSc(errorCode.getCode());
        bxmResponse.setBody(errorCode.getMessage());
        return JsonHelper.convert2bytes((Object)bxmResponse);
    }
}

