/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.aop;

import com.bxm.adsprod.facade.rta.RtaConfig;
import com.bxm.pangu.rta.api.exception.ErrorCode;
import com.bxm.pangu.rta.api.exception.RejectQueryException;
import com.bxm.pangu.rta.api.model.QueryRequest;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class QpsAspect
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(QpsAspect.class);
    @Autowired
    private Counter counter;

    @Pointcut(value="this(com.bxm.pangu.rta.api.service.RtaDispatcher) && execution(* dispatch(..))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object[] args;
        if (log.isDebugEnabled()) {
            log.debug("execute: {}", this.getClass());
        }
        if (ArrayUtils.isEmpty((Object[])(args = point.getArgs()))) {
            return point.proceed();
        }
        Object firstArg = args[0];
        if (!(firstArg instanceof QueryRequest)) {
            return point.proceed();
        }
        QueryRequest request = (QueryRequest)firstArg;
        RtaConfig rtaConfig = request.getRtaConfig();
        if (Objects.isNull(rtaConfig)) {
            return point.proceed();
        }
        String rtaId = request.getRtaId();
        Integer qpsLimit = rtaConfig.getQps();
        Long afterIncrQps = this.counter.incrementAndGet(this.stringQpsLimit(rtaId), 30);
        if (afterIncrQps > (long)qpsLimit.intValue()) {
            throw new RejectQueryException(ErrorCode.Rejected_Request);
        }
        return point.proceed();
    }

    public KeyGenerator stringQpsLimit(String rtaId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"RTA", "QPS", rtaId, QpsAspect.getDateTime()});
    }

    private static String getDateTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

