/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.aop.micrometer;

import com.bxm.pangu.rta.api.service.RtaDispatcher;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TimeCostMicroMeterAspect
implements MeterBinder {
    private MeterRegistry registry;

    @Pointcut(value="this(com.bxm.pangu.rta.api.service.RtaDispatcher) && execution(* dispatch(..))")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof RtaDispatcher)) {
            return point.proceed();
        }
        long start = System.currentTimeMillis();
        Timer timer = this.registry.timer("rta.query.cost", new String[0]);
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            timer.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
        }
    }

    public void bindTo(MeterRegistry meterRegistry) {
        this.registry = meterRegistry;
    }
}

