/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.autoconfigure;

import com.bxm.pangu.rta.api.config.JedisProperties;
import com.bxm.pangu.rta.api.config.RtaApiProperties;
import com.bxm.pangu.rta.api.util.limiter.DefaultDeleteExpiredHandler;
import com.bxm.pangu.rta.api.util.limiter.DeleteExpiredHandler;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@EnableConfigurationProperties(value={JedisProperties.class})
@Configuration
public class LimiterAutoConfiguration {
    private final RtaApiProperties rtaApiProperties;
    private final JedisProperties properties;

    public LimiterAutoConfiguration(RtaApiProperties rtaApiProperties, JedisProperties properties) {
        this.rtaApiProperties = rtaApiProperties;
        this.properties = properties;
    }

    @Bean(name={"limiterJedisPool"})
    public JedisPool limiterJedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.properties, this.properties.getHost(), this.properties.getPort(), this.properties.getTimeout(), this.properties.getPassword(), this.rtaApiProperties.getLimiterDb());
    }

    @Bean(name={"limiterFetcher"})
    public JedisFetcher limiterFetcher(@Qualifier(value="limiterJedisPool") JedisPool limiterJedisPool) {
        return new JedisFetcher(limiterJedisPool);
    }

    @Bean(name={"limiterUpdater"})
    public JedisUpdater limiterUpdater(@Qualifier(value="limiterJedisPool") JedisPool limiterJedisPool) {
        return new JedisUpdater(limiterJedisPool);
    }

    @Bean(name={"limiterCounter"})
    public JedisCounter limiterCounter(@Qualifier(value="limiterJedisPool") JedisPool limiterJedisPool) {
        return new JedisCounter(limiterJedisPool);
    }

    @Bean
    public DeleteExpiredHandler deleteExpiredHandler(@Qualifier(value="limiterUpdater") Updater updater) {
        return new DefaultDeleteExpiredHandler(updater);
    }
}

