/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.service;

import com.bxm.adsprod.facade.rta.RtaConfig;
import com.bxm.pangu.rta.api.model.QueryRequest;
import com.bxm.pangu.rta.api.model.QueryResponse;
import com.bxm.pangu.rta.api.service.QueryHitter;
import com.bxm.pangu.rta.api.service.QueryHitterFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RtaDispatcher {
    private final QueryHitterFactory queryHitterFactory;

    public RtaDispatcher(QueryHitterFactory queryHitterFactory) {
        this.queryHitterFactory = queryHitterFactory;
    }

    public QueryResponse dispatch(QueryRequest queryRequest) {
        RtaConfig rtaConfig = queryRequest.getRtaConfig();
        Byte sourceType = rtaConfig.getSourceType();
        QueryHitter queryHitter = (QueryHitter)this.queryHitterFactory.get(sourceType);
        boolean hit = queryHitter.query(queryRequest);
        return hit ? QueryResponse.ofSuccess(queryRequest) : QueryResponse.ofFailure(queryRequest);
    }
}

