/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.mango;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.mango.MangoResponse;
import com.bxm.pangu.rta.common.mango.MangoRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class MangoRtaClient
extends AbstractHttpClientRtaClient {
    private final MangoRtaProperties properties;

    public MangoRtaClient(MangoRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        String appId = this.properties.getAppId();
        String t = TypeHelper.castToString((Object)System.currentTimeMillis());
        String apiKey = this.properties.getApiKey();
        String token = DigestUtils.md5Hex((String)(appId + apiKey + t)).toLowerCase();
        params.add((Object)"appId", (Object)appId);
        params.add((Object)"timeStamp", (Object)t);
        params.add((Object)"apiToken", (Object)token);
        params.add((Object)"imeiMd5", (Object)Optional.ofNullable(request.getImei_md5()).orElse(""));
        params.add((Object)"imei", (Object)Optional.ofNullable(request.getImei()).orElse(""));
        params.add((Object)"oaidMd5", (Object)Optional.ofNullable(request.getOaid_md5()).orElse(""));
        params.add((Object)"oaid", (Object)Optional.ofNullable(request.getOaid()).orElse(""));
        params.add((Object)"idfaMd5", (Object)Optional.ofNullable(request.getIdfa_md5()).orElse(""));
        params.add((Object)"idfa", (Object)Optional.ofNullable(request.getIdfa()).orElse(""));
        params.add((Object)"type", (Object)request.getParam());
        params.add((Object)"os", (Object)request.getOs());
        String url = UriComponentsBuilder.fromUriString((String)this.properties.getUrl()).replaceQueryParams((MultiValueMap)params).build().toString();
        return new HttpGet(url);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return ((MangoResponse)JsonHelper.convert((String)json, MangoResponse.class)).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Mango;
    }
}

