/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.myhayo;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.myhayo.MyhayoRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class MyhayoRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(MyhayoRtaClient.class);
    private final MyhayoRtaProperties properties;

    public MyhayoRtaClient(MyhayoRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = this.properties.getUrl();
        String channel = this.properties.getChannel();
        String finalUrl = UriComponentsBuilder.fromUriString((String)url).replaceQueryParam("channel", new Object[]{channel}).replaceQueryParam("product", new Object[]{request.getParam()}).replaceQueryParam("imeiMd5", new Object[]{request.getImei_md5()}).replaceQueryParam("oaid", new Object[]{request.getOaid()}).replaceQueryParam("idfaMd5", new Object[]{request.getIdfa_md5()}).build().toString();
        return new HttpGet(finalUrl);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return ((Response)JsonHelper.convert((String)json, Response.class)).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Myhayo;
    }

    private static class Response {
        private String product;
        private String code;
        private List<String> data;

        boolean isTarget() {
            return StringUtils.equals((CharSequence)"0", (CharSequence)this.code);
        }

        public String getProduct() {
            return this.product;
        }

        public String getCode() {
            return this.code;
        }

        public List<String> getData() {
            return this.data;
        }

        public void setProduct(String product) {
            this.product = product;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setData(List<String> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$product = this.getProduct();
            String other$product = other.getProduct();
            if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            List<String> this$data = this.getData();
            List<String> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $product = this.getProduct();
            result = result * 59 + ($product == null ? 43 : $product.hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            List<String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "MyhayoRtaClient.Response(product=" + this.getProduct() + ", code=" + this.getCode() + ", data=" + this.getData() + ")";
        }
    }
}

