/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.taobao;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.taobao.TaobaoRtaProperties;
import com.google.common.collect.Maps;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.request.UsergrowthDhhDeliveryAskRequest;
import com.taobao.api.response.UsergrowthDhhDeliveryAskResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaobaoRtaClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(TaobaoRtaClient.class);
    private final TaobaoRtaProperties properties;
    private final TaobaoClient client;

    public TaobaoRtaClient(TaobaoRtaProperties properties) {
        this.properties = properties;
        String url = properties.getUrl();
        String appKey = properties.getAppKey();
        String appSecret = properties.getAppSecret();
        int connectTimeout = properties.getConnectTimeout();
        int socketTimeout = properties.getSocketTimeout();
        TaobaoLogger.setNeedEnableLogger((boolean)properties.isNeedEnableLogger());
        this.client = new DefaultTaobaoClient(url, appKey, appSecret, "json", connectTimeout, socketTimeout);
    }

    @Override
    public boolean isTarget(RtaRequest req, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        String oaid;
        String idfaMd5;
        UsergrowthDhhDeliveryAskRequest request = new UsergrowthDhhDeliveryAskRequest();
        if (StringUtils.equals((String)req.getOs(), (String)"android")) {
            request.setOs("0");
        } else if (StringUtils.equals((String)req.getOs(), (String)"ios")) {
            request.setOs("1");
        } else {
            request.setOs("3");
        }
        String imeiMd5 = req.getImei_md5();
        if (StringUtils.isNotBlank((String)imeiMd5)) {
            request.setImeiMd5(imeiMd5);
        }
        if (StringUtils.isNotBlank((String)(idfaMd5 = req.getIdfa_md5()))) {
            request.setIdfaMd5(idfaMd5);
        }
        if (StringUtils.isNotBlank((String)(oaid = req.getOaid()))) {
            request.setOaid(oaid);
        }
        String channel = this.properties.getChannel();
        String advertisingSpaceId = this.properties.getAdvertisingSpaceId();
        String param = req.getParam();
        if (StringUtils.isNotBlank((String)param)) {
            String[] params = StringUtils.splitPreserveAllTokens((String)param, (String)"|");
            channel = StringUtils.defaultIfBlank((String)params[0], (String)this.properties.getChannel());
            if (params.length > 1) {
                advertisingSpaceId = StringUtils.defaultIfBlank((String)params[1], (String)this.properties.getAdvertisingSpaceId());
            }
        }
        request.setChannel(channel);
        request.setAdvertisingSpaceId(advertisingSpaceId);
        try {
            boolean hitTarget;
            UsergrowthDhhDeliveryAskResponse response = (UsergrowthDhhDeliveryAskResponse)this.client.execute((TaobaoRequest)request);
            if (Objects.isNull(response)) {
                if (log.isInfoEnabled() && RandomUtils.nextInt((int)99) == 0) {
                    log.info("Taobao rta response is empty!");
                }
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("response: {}", (Object)response.getBody());
            }
            if (hitTarget = Optional.ofNullable(response.getResult()).orElse(false).booleanValue()) {
                String taskId = response.getTaskId();
                if (Objects.nonNull(feedback)) {
                    HashMap res = Maps.newHashMap();
                    res.put("channel", channel);
                    res.put("advertisingSpaceId", advertisingSpaceId);
                    res.put("taskId", taskId);
                    res.put("device", req);
                    feedback.accept(res);
                }
            }
            return hitTarget;
        }
        catch (ApiException e) {
            log.warn("{}", (Object)e.getMessage());
            throw new RtaRequestException(e);
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Taobao;
    }
}

