/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.vlion;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.vlion.VlionResponse;
import com.bxm.pangu.rta.common.vlion.VlionRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class VlionRtaClient
extends AbstractHttpClientRtaClient {
    public VlionRtaClient(VlionRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        boolean flag;
        String url = this.getProperties().getUrl();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        boolean bl = flag = this.putIfNotBlank((MultiValueMap<String, String>)params, "imei", request.getImei()) || this.putIfNotBlank((MultiValueMap<String, String>)params, "imei_md5", request.getImei_md5()) || this.putIfNotBlank((MultiValueMap<String, String>)params, "oaid", request.getOaid()) || this.putIfNotBlank((MultiValueMap<String, String>)params, "oaid_md5", request.getOaid_md5()) || this.putIfNotBlank((MultiValueMap<String, String>)params, "idfa", request.getIdfa()) || this.putIfNotBlank((MultiValueMap<String, String>)params, "idfa_md5", request.getIdfa_md5());
        if (!flag) {
            throw new RtaRequestException("Empty device id.");
        }
        String appConfig = null;
        String param = request.getParam();
        if (StringUtils.isNotBlank((String)param)) {
            String[] arr = this.split(param);
            appConfig = arr[0];
        }
        String app = StringUtils.defaultIfBlank(appConfig, (String)"alipay");
        params.set((Object)"app", (Object)app);
        String finalUrl = UriComponentsBuilder.fromUriString((String)url).replaceQueryParams((MultiValueMap)params).build().toString();
        return new HttpGet(finalUrl);
    }

    private String[] split(String param) {
        return StringUtils.split((String)param, (String)"|");
    }

    private boolean putIfNotBlank(MultiValueMap<String, String> params, String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            params.set((Object)"dp", (Object)name);
            params.set((Object)"d", (Object)value);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        String[] arr;
        VlionResponse response = (VlionResponse)JsonHelper.convert((String)json, VlionResponse.class);
        if (!response.isSuccess()) {
            return false;
        }
        List<VlionResponse.Item> data = response.getData();
        if (CollectionUtils.isEmpty(data)) {
            return false;
        }
        String taskId = null;
        String param = request.getParam();
        if (StringUtils.isNotBlank((String)param) && (arr = this.split(param)).length >= 2) {
            taskId = arr[1];
        }
        String finalTaskId = StringUtils.defaultIfBlank(taskId, (String)"L00016");
        long count = data.stream().filter(e -> e.getDeviceLabel().contains(finalTaskId)).count();
        return count > 0L;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Vlion;
    }
}

