/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.xianjy;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.xianjy.XianjyRequest;
import com.bxm.pangu.rta.common.xianjy.XianjyResponse;
import com.bxm.pangu.rta.common.xianjy.XianjyRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public class XianjyRtaClient
extends AbstractHttpClientRtaClient {
    private final XianjyRtaProperties xianjyRtaProperties;

    public XianjyRtaClient(XianjyRtaProperties properties) {
        super(properties);
        this.xianjyRtaProperties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = this.xianjyRtaProperties.getUrl();
        String platform = StringUtils.isNotBlank((String)request.getParam()) ? request.getParam() : this.xianjyRtaProperties.getDefaultPlatform();
        XianjyRequest.Device0 device0 = new XianjyRequest.Device0().setImeiMd5(request.getImei_md5()).setIdfaMd5(request.getIdfa_md5()).setOaidMd5(request.getOaid_md5());
        XianjyRequest xianjyRequest = new XianjyRequest().setChannel(this.xianjyRtaProperties.getChannel()).setPlatform(platform).setDevice(device0);
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new ByteArrayEntity(JsonHelper.convert2bytes((Object)xianjyRequest)));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return ((XianjyResponse)JsonHelper.convert((String)json, XianjyResponse.class)).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.XiAnJingYu;
    }
}

