/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.zhihu;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.ProtocolFormat;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.zhihu.Zhihu;
import com.bxm.pangu.rta.common.zhihu.ZhihuRtaProperties;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZhihuRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(ZhihuRtaClient.class);
    private final ZhihuRtaProperties properties;

    public ZhihuRtaClient(ZhihuRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        HttpPost post = new HttpPost(this.getProperties().getUrl());
        Zhihu.Req.Builder builder = Zhihu.Req.newBuilder();
        String imei = request.getImei();
        String imeiMd5 = request.getImei_md5();
        String androidid = request.getAndroidid();
        String androididMd5 = request.getAndroidid_md5();
        String oaidMd5 = request.getOaid_md5();
        String oaid = request.getOaid();
        String idfa = request.getIdfa();
        String idfaMd5 = request.getIdfa_md5();
        if (StringUtils.isNotBlank((String)imei)) {
            builder.setDid(imei).setDidType(Zhihu.DidType.IMEI);
        } else if (StringUtils.isNotBlank((String)imeiMd5)) {
            builder.setDid(imeiMd5).setDidType(Zhihu.DidType.IMEI_MD5);
        } else if (StringUtils.isNotBlank((String)androidid)) {
            builder.setDid(androidid).setDidType(Zhihu.DidType.ANDROID_ID);
        } else if (StringUtils.isNotBlank((String)androididMd5)) {
            builder.setDid(androididMd5).setDidType(Zhihu.DidType.ANDROID_ID_MD5);
        } else if (StringUtils.isNotBlank((String)oaid)) {
            builder.setDid(oaid).setDidType(Zhihu.DidType.OAID);
        } else if (StringUtils.isNotBlank((String)oaidMd5)) {
            builder.setDid(oaidMd5).setDidType(Zhihu.DidType.OAID_MD5);
        } else if (StringUtils.isNotBlank((String)idfa)) {
            builder.setDid(idfa).setDidType(Zhihu.DidType.IDFA);
        } else if (StringUtils.isNotBlank((String)idfaMd5)) {
            builder.setDid(idfaMd5).setDidType(Zhihu.DidType.IDFA_MD5);
        }
        Zhihu.Device.Builder deviceBuilder = Zhihu.Device.newBuilder();
        if (StringUtils.isNotBlank((String)imei)) {
            deviceBuilder.setImeiMd5(DigestUtils.md5Hex((String)imei).toLowerCase());
        }
        if (StringUtils.isNotBlank((String)imeiMd5)) {
            deviceBuilder.setImeiMd5(imeiMd5);
        }
        if (StringUtils.isNotBlank((String)androididMd5)) {
            deviceBuilder.setAndroidIdMd5(androididMd5);
        }
        if (StringUtils.isNotBlank((String)oaid)) {
            deviceBuilder.setOaid(oaid);
        }
        if (StringUtils.isNotBlank((String)oaidMd5)) {
            deviceBuilder.setOaidMd5(oaidMd5);
        }
        if (StringUtils.isNotBlank((String)idfa)) {
            deviceBuilder.setIdfa(idfa);
        }
        if (StringUtils.isNotBlank((String)idfaMd5)) {
            deviceBuilder.setIdfaMd5(idfaMd5);
        }
        builder.setDevice(deviceBuilder.build());
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("param must be {slot_id|rta_ids}");
        }
        String[] arr = StringUtils.splitByWholeSeparator((String)param, (String)"|");
        if (arr.length < 2) {
            throw new RtaRequestException("param must be {slot_id|rta_ids}");
        }
        String slotId = arr[0];
        String rtaIds = arr[1];
        builder.setSlotId(NumberUtils.toLong((String)slotId));
        String reqId = RandomStringUtils.randomAlphanumeric((int)8);
        builder.setReqId(reqId);
        builder.addRtaIds(NumberUtils.toLong((String)rtaIds));
        long currentTimeMillis = System.currentTimeMillis();
        builder.setSignTime(currentTimeMillis);
        String identify = this.properties.getIdentify();
        if (arr.length >= 3) {
            identify = arr[2];
        }
        String token = DigestUtils.md5Hex((String)(reqId + currentTimeMillis + identify));
        builder.setToken(token);
        post.addHeader("Content-Type", "application/x-protobuf");
        Zhihu.Req build = builder.build();
        post.setEntity((HttpEntity)new ByteArrayEntity(build.toByteArray()));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Zhihu;
    }

    @Override
    protected boolean isTarget(RtaRequest request, byte[] bytes) {
        try {
            Zhihu.Rsp rsp = Zhihu.Rsp.parseFrom(bytes);
            if (rsp.getStatusCode() != 0) {
                return false;
            }
            if (rsp.getBidType() != 0) {
                return false;
            }
            List<Zhihu.UserInfo> userInfosList = rsp.getUserInfosList();
            if (CollectionUtils.isEmpty(userInfosList)) {
                return false;
            }
            Zhihu.UserInfo userInfo = userInfosList.get(0);
            return userInfo.isInitialized();
        }
        catch (InvalidProtocolBufferException e) {
            log.error("isTarget: ", (Throwable)e);
            return false;
        }
    }

    @Override
    public ProtocolFormat getProtocolFormat() {
        return ProtocolFormat.Protobuf;
    }
}

