package com.bxm.pangu.rta.common.autoconfigure;

import com.bxm.pangu.rta.common.CachingAspect;
import com.bxm.pangu.rta.common.CachingRedisProperties;
import com.bxm.pangu.rta.common.micrometer.RtaClientMicroMeter;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.fetchers.RedisFetcher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
@EnableConfigurationProperties(CachingRedisProperties.class)
public class CachingAutoConfiguration {

    private final CachingRedisProperties properties;

    public CachingAutoConfiguration(CachingRedisProperties properties) {
        this.properties = properties;
    }

    @Bean(name = "cachingJedisPool")
    public JedisPool cachingJedisPool() {
        return new JedisPool(properties, properties.getHost(), properties.getPort(), properties.getTimeout(), properties.getPassword(), properties.getDatabase());
    }

    @Bean(name = "cachingFetcher")
    public Fetcher cachingFetcher(@Qualifier("cachingJedisPool") JedisPool cachingJedisPool) {
        return new RedisFetcher(cachingJedisPool);
    }

    @Bean(name = "cachingCounter")
    public Counter cachingCounter(@Qualifier("cachingJedisPool") JedisPool cachingJedisPool) {
        return new JedisCounter(cachingJedisPool);
    }

    @Bean
    public CachingAspect cachingAspect(@Qualifier("cachingFetcher") Fetcher fetcher,
                                       RtaClientMicroMeter meter) {
        return new CachingAspect(fetcher, properties.getEnableRtaClient(), meter);
    }
}
