package com.bxm.pangu.rta.common.autoconfigure;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientFactory;
import com.bxm.pangu.rta.common.autohome.AutohomeRtaClient;
import com.bxm.pangu.rta.common.autohome.AutohomeRtaProperties;
import com.bxm.pangu.rta.common.baichuan.BaichuanRtaClient;
import com.bxm.pangu.rta.common.baichuan.BaichuanRtaProperties;
import com.bxm.pangu.rta.common.baidu.BaiduRtaClient;
import com.bxm.pangu.rta.common.baidu.BaiduRtaProperties;
import com.bxm.pangu.rta.common.baidu_silent.BaiduSilentRtaClient;
import com.bxm.pangu.rta.common.baidu_silent.BaiduSilentRtaProperties;
import com.bxm.pangu.rta.common.didi.DidiRtaClient;
import com.bxm.pangu.rta.common.didi.DidiRtaProperties;
import com.bxm.pangu.rta.common.douyu.DouyuRtaClient;
import com.bxm.pangu.rta.common.douyu.DouyuRtaProperties;
import com.bxm.pangu.rta.common.getui.GetuiRtaClient;
import com.bxm.pangu.rta.common.getui.GetuiRtaProperties;
import com.bxm.pangu.rta.common.hhdhh.HhdhhRtaClient;
import com.bxm.pangu.rta.common.hhdhh.HhdhhRtaProperties;
import com.bxm.pangu.rta.common.kge.KgeRtaClient;
import com.bxm.pangu.rta.common.kge.KgeRtaProperties;
import com.bxm.pangu.rta.common.mango.MangoRtaClient;
import com.bxm.pangu.rta.common.mango.MangoRtaProperties;
import com.bxm.pangu.rta.common.meituan.MeituanRtaClient;
import com.bxm.pangu.rta.common.meituan.MeituanRtaProperties;
import com.bxm.pangu.rta.common.micrometer.RtaClientMicroMeter;
import com.bxm.pangu.rta.common.micrometer.RtaClientMicroMeterAspect;
import com.bxm.pangu.rta.common.myhayo.MyhayoRtaClient;
import com.bxm.pangu.rta.common.myhayo.MyhayoRtaProperties;
import com.bxm.pangu.rta.common.oneway.OneWayRtaClient;
import com.bxm.pangu.rta.common.oneway.OneWayRtaProperties;
import com.bxm.pangu.rta.common.taobao.TaobaoRtaClient;
import com.bxm.pangu.rta.common.taobao.TaobaoRtaProperties;
import com.bxm.pangu.rta.common.taobao_activity.TaobaoActivityRtaClient;
import com.bxm.pangu.rta.common.taobao_activity.TaobaoActivityRtaProperties;
import com.bxm.pangu.rta.common.tencent.TencentVideoRtaClient;
import com.bxm.pangu.rta.common.tencent.TencentVideoRtaProperties;
import com.bxm.pangu.rta.common.testing.TestingRtaClient;
import com.bxm.pangu.rta.common.testing.TestingRtaProperties;
import com.bxm.pangu.rta.common.vlion.VlionRtaClient;
import com.bxm.pangu.rta.common.vlion.VlionRtaProperties;
import com.bxm.pangu.rta.common.xianjy.XianjyRtaClient;
import com.bxm.pangu.rta.common.xianjy.XianjyRtaProperties;
import com.bxm.pangu.rta.common.yhcs.YhcsRtaClient;
import com.bxm.pangu.rta.common.yhcs.YhcsRtaProperties;
import com.bxm.pangu.rta.common.zhihu.ZhihuRtaClient;
import com.bxm.pangu.rta.common.zhihu.ZhihuRtaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

/**
 * Auto configuration for rta client beans.
 *
 * @author allen
 * @date 2021-12-21
 * @since 1.0
 */
@EnableConfigurationProperties({
        TestingRtaProperties.class,
        GetuiRtaProperties.class,
        OneWayRtaProperties.class,
        BaiduRtaProperties.class,
        HhdhhRtaProperties.class,
        MyhayoRtaProperties.class,
        XianjyRtaProperties.class,
        TaobaoRtaProperties.class,
        MangoRtaProperties.class,
        TencentVideoRtaProperties.class,
        DidiRtaProperties.class,
        VlionRtaProperties.class,
        YhcsRtaProperties.class,
        ZhihuRtaProperties.class,
        BaichuanRtaProperties.class,
        MeituanRtaProperties.class,
        BaiduSilentRtaProperties.class,
        KgeRtaProperties.class,
        DouyuRtaProperties.class,
        TaobaoActivityRtaProperties.class,
        AutohomeRtaProperties.class
})
public class RtaClientAutoConfiguration {

    @Bean
    public TestingRtaClient testingRtaClient(TestingRtaProperties properties) {
        return new TestingRtaClient(properties);
    }

    @Bean
    public GetuiRtaClient getuiRtaClient(GetuiRtaProperties properties) {
        return new GetuiRtaClient(properties);
    }

    @Bean
    public OneWayRtaClient oneWayRtaClient(OneWayRtaProperties properties) {
        return new OneWayRtaClient(properties);
    }

    @Bean
    public BaiduRtaClient baiduRtaClient(BaiduRtaProperties properties) {
        return new BaiduRtaClient(properties);
    }

    @Bean
    public HhdhhRtaClient hhdhhRtaClient(HhdhhRtaProperties properties) {
        return new HhdhhRtaClient(properties);
    }

    @Bean
    public MyhayoRtaClient myhayoRtaClient(MyhayoRtaProperties properties) {
        return new MyhayoRtaClient(properties);
    }

    @Bean
    public XianjyRtaClient xianjyRtaClient(XianjyRtaProperties properties) {
        return new XianjyRtaClient(properties);
    }

    @Bean
    public TaobaoRtaClient taobaoRtaClient(TaobaoRtaProperties properties) {
        return new TaobaoRtaClient(properties);
    }

    @Bean
    public MangoRtaClient mangoRtaClient(MangoRtaProperties properties) {
        return new MangoRtaClient(properties);
    }

    @Bean
    public TencentVideoRtaClient tencentVideoRtaClient(TencentVideoRtaProperties properties) {
        return new TencentVideoRtaClient(properties);
    }

    @Bean
    public DidiRtaClient didiRtaClient(DidiRtaProperties properties) {
        return new DidiRtaClient(properties);
    }

    @Bean
    public VlionRtaClient vlionRtaClient(VlionRtaProperties properties) {
        return new VlionRtaClient(properties);
    }

    @Bean
    public YhcsRtaClient yhcsRtaClient(YhcsRtaProperties properties) {
        return new YhcsRtaClient(properties);
    }

    @Bean
    public ZhihuRtaClient zhihuRtaClient(ZhihuRtaProperties properties) {
        return new ZhihuRtaClient(properties);
    }

    @Bean
    public BaichuanRtaClient baichuanRtaClient(BaichuanRtaProperties properties) {
        return new BaichuanRtaClient(properties);
    }

    @Bean
    public MeituanRtaClient meituanRtaClient(MeituanRtaProperties properties) {
        return new MeituanRtaClient(properties);
    }

    @Bean
    public BaiduSilentRtaClient baiduSilentRtaClient(BaiduSilentRtaProperties properties) {
        return new BaiduSilentRtaClient(properties);
    }

    @Bean
    public KgeRtaClient kgeRtaClient(KgeRtaProperties properties) {
        return new KgeRtaClient(properties);
    }

    @Bean
    public DouyuRtaClient douyuRtaClient(DouyuRtaProperties properties) {
        return new DouyuRtaClient(properties);
    }

    @Bean
    public TaobaoActivityRtaClient taobaoActivityRtaClient(TaobaoActivityRtaProperties properties) {
        return new TaobaoActivityRtaClient(properties);
    }

    @Bean
    public AutohomeRtaClient autohomeRtaClient(AutohomeRtaProperties properties) {
        return new AutohomeRtaClient(properties);
    }

    // ---- about factory ---- //

    @Bean
    public RtaClientFactory rtaClientFactory() {
        return new RtaClientFactory();
    }

    @Bean
    public RtaClientMicroMeter rtaClientMicroMeter(ApplicationContext applicationContext) {
        return new RtaClientMicroMeter(applicationContext.getBeansOfType(RtaClient.class).values());
    }

    @Bean
    public RtaClientMicroMeterAspect rtaClientMicroMeterAspect(RtaClientMicroMeter rtaClientMicroMeter) {
        return new RtaClientMicroMeterAspect(rtaClientMicroMeter);
    }

}
