package com.bxm.pangu.rta.common.didi;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.ProtocolFormat;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

/**
 * 滴滴
 *
 * @author allen
 * @date 2021-12-30
 * @since 1.0
 */
public class DidiRtaClient extends AbstractHttpClientRtaClient {

    public DidiRtaClient(DidiRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        HttpPost post = new HttpPost(getProperties().getUrl());
        post.addHeader("Content-Type", "application/x-protobuf;charset=UTF-8");
//        post.setEntity(new ByteArrayEntity(builder.build().toByteArray()));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isTarget(RtaRequest request, byte[] bytes) {
        return false;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Didi;
    }

    @Override
    public ProtocolFormat getProtocolFormat() {
        return ProtocolFormat.Protobuf;
    }
}
