package com.bxm.pangu.rta.common;

import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * @author allen
 * @date 2022-02-22
 * @since 1.0
 */
public interface RtaClientProperties {

    /**
     * 返回需要报警的请求次数
     *
     * @return 报警的请求次数
     */
    List<Long> getRequestTimesForWarning();

    /**
     * 返回配置可展示的字符串信息
     *
     * @return 字符串，默认 空字符串
     */
    default String toSimpleString() {
        return StringUtils.EMPTY;
    }
}
