package com.bxm.pangu.rta.common.testing;

import com.bxm.pangu.rta.common.*;
import org.apache.commons.lang.math.NumberUtils;

import java.util.Map;
import java.util.function.Consumer;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
public class TestingRtaClient implements RtaClient {

    private final TestingRtaProperties properties;

    public TestingRtaClient(TestingRtaProperties properties) {
        this.properties = properties;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Testing;
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        return NumberUtils.isNumber(request.getImei_md5());
    }

    @Override
    public RtaClientProperties getProperties() {
        return properties;
    }
}
