package com.bxm.pangu.rta.common.yhcs;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author allen
 * @date 2022-01-10
 * @since 1.0
 */
public class YhcsRtaClient extends AbstractHttpClientRtaClient {

    public YhcsRtaClient(YhcsRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = getProperties().getUrl();

        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();

        boolean flag = putIfNotBlank(params, "imei_md5", request.getImei_md5()) ||
                       putIfNotBlank(params, "oaid_md5", request.getOaid_md5());
        if (!flag) {
            throw new RtaRequestException("Empty device id.");
        }

        // {key}|{uid}
        String param = request.getParam();
        if (StringUtils.isBlank(param)) {
            throw new IllegalArgumentException("param");
        }
        String[] arr = StringUtils.splitByWholeSeparator(param, "|");
        if (arr.length < 2) {
            throw new IllegalArgumentException("param");
        }
        String key = arr[0];
        String uid = arr[1];
        params.set("key", key);
        params.set("uid", uid);

        String finalUrl = UriComponentsBuilder.fromUriString(url).replaceQueryParams(params).build().toString();

        return new HttpGet(finalUrl);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        YhcsResponse res = JsonHelper.convert(json, YhcsResponse.class);
        return res.isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Yhcs;
    }

    private boolean putIfNotBlank(MultiValueMap<String, String> params, String name, String value) {
        if (StringUtils.isNotBlank(value)) {
            params.set("dp", name);
            params.set("d", value);
            return true;
        }
        return false;
    }
}
