package com.bxm.pangu.rta.common.changba;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.mango.MangoRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * 唱吧
 *
 * @author tangxiao
 * @date 2022-10-25
 * @since 1.0
 */
public class ChangbaRtaClient extends AbstractHttpClientRtaClient {
    private final ChangbaRtaProperties properties;

    private static final String OS_ANDROID = "0";
    private static final String OS_IOS = "1";


    public ChangbaRtaClient(ChangbaRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {

        String param = request.getParam();
        if (StringUtils.isBlank(param)) {
            throw new IllegalArgumentException("param");
        }

        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();

        params.add("ac", "rtatrack");
        params.add("check_ids", param);
        params.add("imei_md5", Optional.ofNullable(request.getImei_md5()).orElse(StringUtils.EMPTY));
        params.add("oaid_md5", Optional.ofNullable(request.getOaid_md5()).orElse(StringUtils.EMPTY));
        params.add("idfa_md5", Optional.ofNullable(request.getIdfa_md5()).orElse(StringUtils.EMPTY));
        params.add("android_id_md5", Optional.ofNullable(request.getAndroidid_md5()).orElse(StringUtils.EMPTY));

        if (StringUtils.isNotBlank(request.getOs())) {
            params.add("os", "android".equals(request.getOs()) ? OS_ANDROID : ("ios".equals(request.getOs()) ? OS_IOS : ""));
        } else {
            params.add("os", StringUtils.isNotBlank(request.getIdfa_md5()) ? OS_IOS : OS_ANDROID);
        }

        String url = UriComponentsBuilder.fromUriString(properties.getUrl()).replaceQueryParams(params).build().toString();
        return new HttpGet(url);
    }


    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        Res res = JsonHelper.convert(json, Res.class);
        if (Objects.isNull(res)) {
            return false;
        }
        if (!StringUtils.equals("0", res.getCode())) {
            return false;
        }

        String param = request.getParam();
        if (StringUtils.isBlank(param)) {
            throw new RtaRequestException("param");
        }

        return StringUtils.isNotBlank(res.getDeliver_ids());

    }

    @Override
    public RtaType getRtaType() {
        return RtaType.ChangBa;
    }


    @Data
    private static class Res {

        private String Code;
        private String Message;
        private String Deliver_ids;
        private String Filter_ids;
    }

}
