/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.autohome;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.autohome.AutohomeRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

public class AutohomeRtaClient
extends AbstractHttpClientRtaClient {
    public AutohomeRtaClient(AutohomeRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = this.getProperties().getUrl();
        String channel = Optional.ofNullable(request.getParam()).orElse("JYM2022_SF");
        String id = request.getImei_md5();
        if (StringUtils.isBlank((String)id)) {
            id = request.getOaid_md5();
        }
        if (StringUtils.isBlank((String)id)) {
            id = request.getIdfa_md5();
        }
        if (StringUtils.isBlank((String)id)) {
            id = request.getAndroidid_md5();
        }
        if (StringUtils.isBlank((String)id)) {
            id = request.getIdfa_md5();
        }
        String finalUrl = UriComponentsBuilder.fromUriString((String)url).replaceQueryParam("id", new Object[]{id}).replaceQueryParam("idkind", new Object[]{"2"}).replaceQueryParam("channel", new Object[]{channel}).build().toString();
        return new HttpGet(finalUrl);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return ((Response)JsonHelper.convert((String)json, Response.class)).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Autohome;
    }

    private static class Response {
        private String returncode;
        private boolean result;

        public boolean isTarget() {
            return StringUtils.equalsIgnoreCase((String)this.returncode, (String)"0") && this.result;
        }

        public String getReturncode() {
            return this.returncode;
        }

        public boolean isResult() {
            return this.result;
        }

        public void setReturncode(String returncode) {
            this.returncode = returncode;
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isResult() != other.isResult()) {
                return false;
            }
            String this$returncode = this.getReturncode();
            String other$returncode = other.getReturncode();
            return !(this$returncode == null ? other$returncode != null : !this$returncode.equals(other$returncode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isResult() ? 79 : 97);
            String $returncode = this.getReturncode();
            result = result * 59 + ($returncode == null ? 43 : $returncode.hashCode());
            return result;
        }

        public String toString() {
            return "AutohomeRtaClient.Response(returncode=" + this.getReturncode() + ", result=" + this.isResult() + ")";
        }
    }
}

