/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.baichuan;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.baichuan.BaichuanRequest;
import com.bxm.pangu.rta.common.baichuan.BaichuanResponse;
import com.bxm.pangu.rta.common.baichuan.BaichuanRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public class BaichuanRtaClient
extends AbstractHttpClientRtaClient {
    private final BaichuanRtaProperties properties;

    public BaichuanRtaClient(BaichuanRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        HttpPost post = new HttpPost(this.properties.getUrl());
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        BaichuanRequest.DeviceMsg deviceMsg = new BaichuanRequest.DeviceMsg().setImei(request.getImei()).setImeiMd5(request.getImei_md5()).setOaid(request.getOaid()).setOaidMd5(request.getOaid_md5()).setIdfa(request.getIdfa()).setIdfaMd5(request.getIdfa_md5());
        BaichuanRequest bc = new BaichuanRequest().setChannel(this.properties.getChannel()).setDeviceMsgList(Lists.newArrayList((Object[])new BaichuanRequest.DeviceMsg[]{deviceMsg}));
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)bc), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        BaichuanResponse response = (BaichuanResponse)JsonHelper.convert((String)json, BaichuanResponse.class);
        if (!response.isRequestOk()) {
            return false;
        }
        List<BaichuanResponse.Data> data = response.getData();
        return CollectionUtils.isNotEmpty(data) && data.get(0).getRtaIdList().contains(request.getParam());
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Baichuan;
    }
}

