/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.jdjr;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.AbstractRtaProperties;
import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.jdjr.MarketShowAdBatchRequest;
import com.bxm.pangu.rta.common.jdjr.MarketShowAdBatchResponse;
import com.bxm.warcar.utils.SafeMapHelper;
import com.jddglobal.open.client.JddClient;
import com.jddglobal.open.request.base.JddRequest;
import com.jddglobal.open.support.config.EsuSdkConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdjrRtaClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(JdjrRtaClient.class);
    private static final String FID = "eWh1ODQ3c2oyMDR1NGo0anI4M2VyNQ";
    private static final String CHANNEL_CODE = "bianxianmao";
    private final AbstractRtaProperties properties;
    private final ConcurrentHashMap<String, JddClient> clients = new ConcurrentHashMap();

    public JdjrRtaClient(AbstractRtaProperties properties) {
        this.properties = properties;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Jd;
    }

    @Override
    public RtaClientProperties getProperties() {
        return this.properties;
    }

    private JddClient getClient(String fid) {
        return (JddClient)SafeMapHelper.get(this.clients, (Object)fid, () -> EsuSdkConfig.getJddClient());
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        String idType = null;
        String idMd5Value = null;
        String idfaMd5 = request.getIdfa_md5();
        if (StringUtils.isNotBlank((String)idfaMd5)) {
            idType = "idfa";
            idMd5Value = idfaMd5;
        }
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isBlank((String)idMd5Value) && StringUtils.isNotBlank((String)imeiMd5)) {
            idType = "imei";
            idMd5Value = imeiMd5;
        }
        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank((String)idMd5Value) && StringUtils.isNotBlank((String)oaidMd5)) {
            idType = "oaid";
            idMd5Value = oaidMd5;
        }
        if (StringUtils.isBlank((String)idMd5Value)) {
            throw new RtaRequestException("device number is empty");
        }
        try {
            Map<String, Map<String, Object>> data;
            MarketShowAdBatchRequest rtaRequest = new MarketShowAdBatchRequest();
            rtaRequest.setChannelCode(CHANNEL_CODE);
            rtaRequest.setFid(FID);
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            HashMap<String, String> oaid = new HashMap<String, String>();
            oaid.put("idType", idType);
            oaid.put("idMd5Value", idMd5Value);
            list.add(oaid);
            rtaRequest.setDeviceIds(list);
            JddClient jddClient = this.getClient(FID);
            MarketShowAdBatchResponse response = (MarketShowAdBatchResponse)jddClient.execute((JddRequest)rtaRequest);
            if (log.isDebugEnabled()) {
                log.debug("\u4eac\u4e1c\u91d1\u878d response : {}", (Object)JSONObject.toJSONString((Object)((Object)response)));
            }
            if (MapUtils.isEmpty(data = response.getData())) {
                return false;
            }
            Map<String, Object> deviceResult = data.get(idMd5Value);
            return !MapUtils.isEmpty(deviceResult) && !"n".equals(deviceResult.get("show"));
        }
        catch (Exception e) {
            throw new RtaRequestException(e);
        }
    }
}

